/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.animation.client;

import com.google.gson.JsonObject;
import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public record AnimationMetadata(boolean movement, Perspective perspective, boolean fpsCamera, boolean hideHandItems, boolean hideHud, boolean fpsCameraCopiesHead, JsonObject excess) {
    public static final AnimationMetadata DEFAULT = new AnimationMetadata(true, null, true, true, false, false, new JsonObject());

    @Nullable
    public static AnimationMetadata getFor(AnimatedEntity animated) {
        BedrockAnimation anim = BedrockAnimation.getFor(animated);
        if (anim == null) {
            return null;
        }
        AnimationMetadata metadata = anim.metadata;
        return metadata;
    }

    @Generated
    public AnimationMetadata withMovement(boolean movement) {
        return this.movement == movement ? this : new AnimationMetadata(movement, this.perspective, this.fpsCamera, this.hideHandItems, this.hideHud, this.fpsCameraCopiesHead, this.excess);
    }

    @Generated
    public AnimationMetadata withPerspective(Perspective perspective) {
        return this.perspective == perspective ? this : new AnimationMetadata(this.movement, perspective, this.fpsCamera, this.hideHandItems, this.hideHud, this.fpsCameraCopiesHead, this.excess);
    }

    @Generated
    public AnimationMetadata withFpsCamera(boolean fpsCamera) {
        return this.fpsCamera == fpsCamera ? this : new AnimationMetadata(this.movement, this.perspective, fpsCamera, this.hideHandItems, this.hideHud, this.fpsCameraCopiesHead, this.excess);
    }

    @Generated
    public AnimationMetadata withHideHandItems(boolean hideHandItems) {
        return this.hideHandItems == hideHandItems ? this : new AnimationMetadata(this.movement, this.perspective, this.fpsCamera, hideHandItems, this.hideHud, this.fpsCameraCopiesHead, this.excess);
    }

    @Generated
    public AnimationMetadata withHideHud(boolean hideHud) {
        return this.hideHud == hideHud ? this : new AnimationMetadata(this.movement, this.perspective, this.fpsCamera, this.hideHandItems, hideHud, this.fpsCameraCopiesHead, this.excess);
    }

    @Generated
    public AnimationMetadata withFpsCameraCopiesHead(boolean fpsCameraCopiesHead) {
        return this.fpsCameraCopiesHead == fpsCameraCopiesHead ? this : new AnimationMetadata(this.movement, this.perspective, this.fpsCamera, this.hideHandItems, this.hideHud, fpsCameraCopiesHead, this.excess);
    }

    @Generated
    public AnimationMetadata withExcess(JsonObject excess) {
        return this.excess == excess ? this : new AnimationMetadata(this.movement, this.perspective, this.fpsCamera, this.hideHandItems, this.hideHud, this.fpsCameraCopiesHead, excess);
    }

    public static enum Perspective {
        FIRST_PERSON(true, false),
        THIRD_PERSON_BACK(false, false),
        THIRD_PERSON_FRONT(false, true);

        private final boolean firstPerson;
        private final boolean frontView;

        private Perspective(boolean firstPerson, boolean frontView) {
            this.firstPerson = firstPerson;
            this.frontView = frontView;
        }

        @Generated
        public boolean isFirstPerson() {
            return this.firstPerson;
        }

        @Generated
        public boolean isFrontView() {
            return this.frontView;
        }
    }
}

