/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.animation.client;

import dev.amble.lib.animation.EffectProvider;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.minecraft.class_1922;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class WorldPosition {
    private static final WorldPosition INSTANCE = new WorldPosition();
    private class_1922 area;
    private class_243 pos = class_243.field_1353;
    private final Vector3f horizontalPlane = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f verticalPlane = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f diagonalPlane = new Vector3f(1.0f, 0.0f, 0.0f);
    private float pitch;
    private float yaw;
    private final Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);

    protected void moveBy(double x, double y, double z) {
        double d = (double)this.horizontalPlane.x() * x + (double)this.verticalPlane.x() * y + (double)this.diagonalPlane.x() * z;
        double e = (double)this.horizontalPlane.y() * x + (double)this.verticalPlane.y() * y + (double)this.diagonalPlane.y() * z;
        double f = (double)this.horizontalPlane.z() * x + (double)this.verticalPlane.z() * y + (double)this.diagonalPlane.z() * z;
        this.setPos(new class_243(this.pos.field_1352 + d, this.pos.field_1351 + e, this.pos.field_1350 + f));
    }

    protected void setRotation(float yaw, float pitch) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.rotation.rotationYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        this.horizontalPlane.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation);
        this.verticalPlane.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        this.diagonalPlane.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation);
    }

    protected void setRotation(class_243 rotation) {
        class_3545<Float, Float> rots = BedrockAnimation.eulerToPitchYaw(rotation);
        this.pitch = ((Float)rots.method_15442()).floatValue();
        this.yaw = ((Float)rots.method_15441()).floatValue();
        this.rotation.rotationXYZ((float)rotation.method_10216(), (float)rotation.method_10214(), (float)rotation.method_10215());
        this.horizontalPlane.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation);
        this.verticalPlane.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        this.diagonalPlane.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation);
    }

    protected void setPos(double x, double y, double z) {
        this.setPos(new class_243(x, y, z));
    }

    protected void setPos(class_243 pos) {
        this.pos = pos;
    }

    public void spawnParticle(class_2394 particle, class_243 velocity, int count) {
        class_1922 class_19222 = this.area;
        if (!(class_19222 instanceof class_638)) {
            return;
        }
        class_638 world = (class_638)class_19222;
        for (int i = 0; i < count; ++i) {
            world.method_8406(particle, this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    public WorldPosition update(BedrockAnimation anim, String boneName, float progress, EffectProvider target, class_630 root) {
        float f;
        float entityYaw;
        float tickDelta = class_310.method_1551().method_1488();
        this.area = target.getWorld();
        this.setPos(target.getEffectPosition(tickDelta));
        class_243 position = anim.boneTimelines.containsKey(boneName) ? anim.boneTimelines.get(boneName).position().resolve(progress) : class_243.field_1353;
        class_243 animRotation = anim.boneTimelines.containsKey(boneName) ? anim.boneTimelines.get(boneName).rotation().resolve(progress) : class_243.field_1353;
        AtomicReference<Float> height = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> lowest = new AtomicReference<Float>(Float.valueOf(0.0f));
        class_630 bone = root.method_32088().filter(part -> part.method_41919(boneName)).findFirst().map(part -> part.method_32086(boneName)).orElse(null);
        if (bone != null) {
            position = position.method_1031((double)bone.method_41921().field_27702, (double)bone.method_41921().field_27703, (double)bone.method_41921().field_27704);
            bone.method_35745(new class_4587(), (matrix, path, index, cuboid) -> height.updateAndGet(v -> Float.valueOf(cuboid.field_3644 + bone.method_41921().field_27703 + -26.88f)));
            root.method_35745(new class_4587(), (matrix, path, index, cuboid) -> lowest.updateAndGet(v -> Float.valueOf(Math.max(v.floatValue(), cuboid.field_3647 + bone.method_41921().field_27703))));
        }
        class_3545<Float, Float> rots = anim.getRotations(boneName, progress);
        float animYaw = ((Float)rots.method_15441()).floatValue();
        float animPitch = ((Float)rots.method_15442()).floatValue();
        if (anim.metadata.fpsCameraCopiesHead()) {
            float f2;
            if (target instanceof class_746) {
                class_746 clientPlayer = (class_746)target;
                f2 = class_3532.method_17821((float)tickDelta, (float)clientPlayer.field_6259, (float)clientPlayer.field_6241);
            } else {
                f2 = target.getHeadYaw();
            }
            entityYaw = f2;
        } else if (target instanceof class_746) {
            class_746 clientPlayer = (class_746)target;
            v1 = class_3532.method_17821((float)tickDelta, (float)clientPlayer.field_6220, (float)clientPlayer.field_6283);
        } else {
            v1 = entityYaw = target.getBodyYaw();
        }
        if (target instanceof class_746) {
            class_746 clientPlayer = (class_746)target;
            f = class_3532.method_16439((float)tickDelta, (float)clientPlayer.field_6004, (float)clientPlayer.method_5695(tickDelta));
        } else {
            f = target.getPitch();
        }
        float entityPitch = f;
        class_243 relativePos = position.method_1024((float)Math.toRadians(90.0)).method_1021(-0.0625);
        this.setRotation(entityYaw, 0.0f);
        this.moveBy(relativePos.field_1352, relativePos.field_1351 + 1.68, relativePos.field_1350);
        this.setRotation(animYaw + entityYaw, animPitch);
        this.moveBy(0.0, height.get().floatValue() / 32.0f, 0.0);
        return this;
    }

    public static WorldPosition create(BedrockAnimation anim, String part, float progress, EffectProvider target, class_630 root) {
        return new WorldPosition().update(anim, part, progress, target, root);
    }

    public static WorldPosition get(BedrockAnimation anim, String part, float progress, EffectProvider target, class_630 root) {
        return INSTANCE.update(anim, part, progress, target, root);
    }

    @Generated
    public class_243 getPos() {
        return this.pos;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }
}

