/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.api;

import dev.amble.lib.data.DirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_4076;
import net.minecraft.class_5321;

public class WorldUtil {
    private static final int SAFE_RADIUS = 3;

    public static DirectedGlobalPos locateSafe(DirectedGlobalPos cached, GroundSearch vSearch, boolean hSearch) {
        class_2338 temp;
        class_2338 pos;
        class_3218 world = ServerLifecycleHooks.get().method_3847(cached.getDimension());
        if (WorldUtil.isSafe((class_1937)world, pos = cached.getPos())) {
            return cached;
        }
        if (hSearch && (temp = WorldUtil.findSafeXZ(world, pos, 3)) != null) {
            return cached.pos(temp);
        }
        int x = pos.method_10263();
        int z = pos.method_10260();
        int y = switch (vSearch) {
            default -> throw new IncompatibleClassChangeError();
            case GroundSearch.CEILING -> WorldUtil.findSafeTopY(world, pos);
            case GroundSearch.FLOOR -> WorldUtil.findSafeBottomY(world, pos);
            case GroundSearch.MEDIAN -> WorldUtil.findSafeMedianY(world, pos);
            case GroundSearch.NONE -> pos.method_10264();
        };
        return cached.pos(x, y, z);
    }

    private static class_2338 findSafeXZ(class_3218 world, class_2338 original, int radius) {
        class_2338.class_2339 pos = original.method_25503();
        int minX = pos.method_10263() - radius;
        int maxX = pos.method_10263() + radius;
        int minZ = pos.method_10260() - radius;
        int maxZ = pos.method_10260() + radius;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                pos.method_33097(x).method_33099(z);
                if (!WorldUtil.isSafe((class_1937)world, (class_2338)pos)) continue;
                return pos;
            }
        }
        return null;
    }

    private static int findSafeMedianY(class_3218 world, class_2338 pos) {
        class_2338 upCursor = pos;
        class_2680 floorUp = world.method_8320(upCursor.method_10074());
        class_2680 curUp = world.method_8320(upCursor);
        class_2680 aboveUp = world.method_8320(upCursor.method_10084());
        class_2338 downCursor = pos;
        class_2680 floorDown = world.method_8320(downCursor.method_10074());
        class_2680 curDown = world.method_8320(downCursor);
        class_2680 aboveDown = world.method_8320(downCursor.method_10084());
        while (true) {
            boolean canGoDown;
            boolean canGoUp = upCursor.method_10264() < world.method_31600();
            boolean bl = canGoDown = downCursor.method_10264() > world.method_31607();
            if (!canGoUp && !canGoDown) {
                return pos.method_10264();
            }
            if (canGoUp) {
                if (WorldUtil.isSafe(floorUp, curUp, aboveUp)) {
                    return upCursor.method_10264() - 1;
                }
                upCursor = upCursor.method_10084();
                floorUp = curUp;
                curUp = aboveUp;
                aboveUp = world.method_8320(upCursor);
            }
            if (!canGoDown) continue;
            if (WorldUtil.isSafe(floorDown, curDown, aboveDown)) {
                return downCursor.method_10264() + 1;
            }
            downCursor = downCursor.method_10074();
            curDown = aboveDown;
            aboveDown = floorDown;
            floorDown = world.method_8320(downCursor);
        }
    }

    private static int findSafeBottomY(class_3218 world, class_2338 pos) {
        class_2338 cursor = pos.method_33096(world.method_31607() + 2);
        class_2680 floor = world.method_8320(cursor.method_10074());
        class_2680 current = world.method_8320(cursor);
        class_2680 above = world.method_8320(cursor.method_10084());
        while (cursor.method_10264() <= world.method_31600()) {
            if (WorldUtil.isSafe(floor, current, above)) {
                return cursor.method_10264() - 1;
            }
            cursor = cursor.method_10084();
            floor = current;
            current = above;
            above = world.method_8320(cursor);
        }
        return pos.method_10264();
    }

    private static int findSafeTopY(class_3218 world, class_2338 pos) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        return world.method_8497(class_4076.method_18675((int)x), class_4076.method_18675((int)z)).method_12005(class_2902.class_2903.field_13203, x & 0xF, z & 0xF) + 1;
    }

    private static boolean isSafe(class_2680 floor, class_2680 block1, class_2680 block2) {
        return WorldUtil.isFloor(floor) && !block1.method_51366() && !block2.method_51366();
    }

    private static boolean isSafe(class_2680 block1, class_2680 block2) {
        return !block1.method_51366() && !block2.method_51366();
    }

    private static boolean isFloor(class_2680 floor) {
        return floor.method_51366();
    }

    private static boolean isSafe(class_1937 world, class_2338 pos) {
        class_2680 floor = world.method_8320(pos.method_10074());
        if (!WorldUtil.isFloor(floor)) {
            return false;
        }
        class_2680 curUp = world.method_8320(pos);
        class_2680 aboveUp = world.method_8320(pos.method_10084());
        return WorldUtil.isSafe(curUp, aboveUp);
    }

    public static class_2561 worldText(class_5321<class_1937> key) {
        return class_2561.method_48321((String)key.method_29177().method_42093("dimension"), (String)WorldUtil.fakeTranslate(key));
    }

    private static String fakeTranslate(class_5321<class_1937> id) {
        return WorldUtil.fakeTranslate(id.method_29177());
    }

    private static String fakeTranslate(class_2960 id) {
        return WorldUtil.fakeTranslate(id.method_12832());
    }

    private static String fakeTranslate(String path) {
        CharSequence[] words = path.split("_");
        for (int i = 0; i < words.length; ++i) {
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase() + ((String)words[i]).substring(1).toLowerCase();
        }
        return String.join((CharSequence)" ", words);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GroundSearch implements class_3542
    {
        NONE{

            @Override
            public GroundSearch next() {
                return FLOOR;
            }
        }
        ,
        FLOOR{

            @Override
            public GroundSearch next() {
                return CEILING;
            }
        }
        ,
        CEILING{

            @Override
            public GroundSearch next() {
                return MEDIAN;
            }
        }
        ,
        MEDIAN{

            @Override
            public GroundSearch next() {
                return NONE;
            }
        };


        public String method_15434() {
            return this.toString();
        }

        public abstract GroundSearch next();
    }
}

