/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.block;

import dev.amble.lib.block.ABlockSettings;
import dev.amble.lib.block.behavior.api.BlockBehavior;
import dev.amble.lib.block.behavior.api.BlockBehaviorLike;
import dev.amble.lib.block.behavior.api.BlockBehaviors;
import dev.amble.lib.block.behavior.base.BlockPlacementBehavior;
import dev.amble.lib.block.behavior.base.BlockRotationBehavior;
import dev.amble.lib.block.behavior.base.BlockWithEntityBehavior;
import dev.amble.lib.block.behavior.base.RenderBlockBehavior;
import dev.amble.lib.blockentity.ABlockEntity;
import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ABlock
extends class_2248 {
    private final RenderBlockBehavior render;
    private final BlockPlacementBehavior placement;
    private final BlockRotationBehavior rotation;
    private final BlockWithEntityBehavior entity;

    private static BlockBehavior[] flatBehavior(BlockBehaviorLike[] groups) {
        BlockBehavior[] behaviors = BlockBehaviors.behaviors.toArray(new BlockBehavior[0]);
        for (BlockBehaviorLike like : groups) {
            like.unwrap(behaviors);
        }
        return behaviors;
    }

    private static ABlockSettings attachProperties(ABlockSettings settings, BlockBehavior[] behaviors) {
        ArrayList properties = new ArrayList();
        for (BlockBehavior behavior : behaviors) {
            if (behavior == null) continue;
            behavior.appendProperties(properties);
        }
        return settings.properties(properties.toArray(new class_2769[0]));
    }

    public ABlock(ABlockSettings settings, BlockBehaviorLike ... behaviorGroups) {
        this(settings, ABlock.flatBehavior(behaviorGroups));
    }

    private ABlock(ABlockSettings settings, BlockBehavior[] behaviors) {
        super((class_4970.class_2251)ABlock.attachProperties(settings, behaviors));
        class_2680 defState = this.createDefaultState();
        for (BlockBehavior behavior : behaviors) {
            if (behavior == null) continue;
            behavior.init(this);
            defState = behavior.initDefaultState(this, defState);
        }
        this.method_9590(defState);
        this.render = (RenderBlockBehavior)behaviors[BlockBehaviors.RENDER_BLOCK];
        this.placement = (BlockPlacementBehavior)behaviors[BlockBehaviors.BLOCK_PLACEMENT];
        this.rotation = (BlockRotationBehavior)behaviors[BlockBehaviors.BLOCK_ROTATION];
        this.entity = (BlockWithEntityBehavior)behaviors[BlockBehaviors.BLOCK_WITH_ENTITY];
    }

    protected class_2680 createDefaultState() {
        return this.method_9564();
    }

    public class_2464 method_9604(class_2680 state) {
        return this.render.getRenderType(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.getPlacementState(this.method_9564(), ctx);
    }

    @Nullable
    protected class_2680 getPlacementState(class_2680 state, class_1750 ctx) {
        return this.placement.getPlacementState(state, ctx);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return this.rotation.rotate(state, rotation);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return this.rotation.mirror(state, mirror);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862;
        if (this.entity != null && !state.method_27852(newState.method_26204()) && (class_25862 = world.method_8321(pos)) instanceof ABlockEntity) {
            ABlockEntity blockEntity = (ABlockEntity)class_25862;
            blockEntity.onBreak(state, world, pos, newState);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        if (this.entity != null && (class_25862 = world.method_8321(pos)) instanceof ABlockEntity) {
            ABlockEntity be = (ABlockEntity)class_25862;
            return be.onUse(state, world, pos, player, hand, hit);
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862;
        if (this.entity != null && (class_25862 = world.method_8321(pos)) instanceof ABlockEntity) {
            ABlockEntity be = (ABlockEntity)class_25862;
            be.onPlaced(world, pos, state, placer, stack);
        }
        super.method_9567(world, pos, state, placer, stack);
    }

    @Nullable
    public class_2586 createBlockEntity(class_2338 pos, class_2680 state) {
        return this.entity.createBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> getTicker(class_1937 world, class_2680 state, class_2591<T> type) {
        return this.entity.getTicker(world, state, type);
    }
}

