/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.animation.EffectProvider;
import dev.amble.lib.animation.client.AnimationMetadata;
import dev.amble.lib.client.bedrock.BedrockAnimationAdapter;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.lib.client.bedrock.BedrockModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_630;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimation {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BedrockModel.LocatorBone.class, (Object)new BedrockModel.LocatorBone.Adapter()).registerTypeAdapter(BedrockAnimation.class, (Object)new BedrockAnimationAdapter()).create();
    public static boolean IS_RENDERING_PLAYER = false;
    public static boolean IS_RENDERING_HEAD = false;
    public static float HEAD_HIDE_DISTANCE = 0.5f;
    public static Optional<Boolean> WAS_HUD_HIDDEN = Optional.empty();
    public static final Collection<String> IGNORED_BONES = Set.of("camera");
    public static final Collection<String> ROOT_BONES = Set.of("root", "player");
    public final boolean shouldLoop;
    public final double animationLength;
    public final Map<String, BoneTimeline> boneTimelines;
    public final boolean overrideBones;
    public final AnimationMetadata metadata;
    public final Map<Double, class_2960> sounds;
    public String name;

    @Nullable
    public static BedrockAnimation getFor(AnimatedEntity animated) {
        BedrockAnimationReference ref = animated.getCurrentAnimation();
        if (ref == null) {
            return null;
        }
        BedrockAnimation anim = ref.get().orElse(null);
        if (anim == null) {
            return null;
        }
        class_7094 state = animated.getAnimationState();
        if (state == null || anim.isFinished(state)) {
            return null;
        }
        return anim;
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(class_630 root, double runningSeconds) {
        boolean isComplete;
        this.resetBones(root, this.overrideBones);
        this.boneTimelines.forEach((boneName, timeline) -> {
            try {
                if (IGNORED_BONES.contains(boneName.toLowerCase())) {
                    return;
                }
                class_630 bone = root.method_32088().filter(part -> part.method_41919(boneName)).findFirst().map(part -> part.method_32086(boneName)).orElse(null);
                if (bone == null) {
                    if (ROOT_BONES.contains(boneName.toLowerCase())) {
                        bone = root;
                    } else {
                        throw new IllegalStateException("Bone " + boneName + " not found in model. If this is the root part, ensure it is named 'root'.");
                    }
                }
                if (!timeline.position.isEmpty()) {
                    class_243 position = timeline.position.resolve(runningSeconds);
                    bone.method_32088().forEach(child -> {
                        child.field_3657 += (float)position.field_1352;
                        child.field_3656 += (float)position.field_1351;
                        child.field_3655 += (float)position.field_1350;
                    });
                }
                if (!timeline.rotation.isEmpty()) {
                    class_243 rotation = timeline.rotation.resolve(runningSeconds);
                    bone.field_3654 += (float)Math.toRadians((float)rotation.field_1352);
                    bone.field_3675 += (float)Math.toRadians((float)rotation.field_1351);
                    bone.field_3674 += (float)Math.toRadians((float)rotation.field_1350);
                }
                if (!timeline.scale.isEmpty()) {
                    class_243 scale = timeline.scale.resolve(runningSeconds);
                    bone.method_32088().forEach(child -> {
                        child.field_37938 = (float)scale.field_1352;
                        child.field_37939 = (float)scale.field_1351;
                        child.field_37940 = (float)scale.field_1350;
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        boolean bl = isComplete = !this.shouldLoop && runningSeconds >= this.animationLength;
        if (isComplete) {
            this.resetBones(root, true);
        }
    }

    public void applyEffects(@Nullable EffectProvider provider, double current, double previous, @Nullable class_630 root) {
        if (root != null) {
            // empty if block
        }
        if (provider instanceof class_1297) {
            class_1297 entity = (class_1297)provider;
            if (!this.metadata.movement()) {
                entity.method_18799(class_243.field_1353);
                entity.field_6017 = 0.0f;
                if (entity instanceof class_1309) {
                    class_1309 living = (class_1309)entity;
                    living.field_42108.method_48567(0.0f);
                }
            }
        }
        if (this.sounds == null || this.sounds.isEmpty()) {
            return;
        }
        for (Map.Entry<Double, class_2960> entry : this.sounds.entrySet()) {
            double time = entry.getKey();
            class_2960 soundId = entry.getValue();
            if (!(previous <= time) || !(current >= time)) continue;
            class_3414 event = class_3414.method_47908((class_2960)soundId);
            if (provider != null) {
                if (provider.isSilent()) continue;
                class_243 pos = provider.getEffectPosition(class_310.method_1551().method_1488());
                provider.getWorld().method_43128((class_1657)class_310.method_1551().field_1724, pos.field_1352, pos.field_1351, pos.field_1350, event, provider.getSoundCategory(), 1.0f, 1.0f);
                continue;
            }
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)event, (float)1.0f, (float)1.0f));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(class_630 root, class_7094 state, float progress, float speedMultiplier, @Nullable EffectProvider source) {
        double previous = this.getRunningSeconds(state);
        double seconds = this.getRunningSeconds(state, progress, speedMultiplier);
        state.method_41323(s -> {
            this.apply(root, seconds);
            this.applyEffects(source, seconds, previous, root);
        });
    }

    public void apply(class_630 root, int totalTicks, float rawDelta) {
        float ticks = (float)((double)((float)totalTicks / 20.0f) % this.animationLength) * 20.0f;
        float delta = rawDelta / 10.0f;
        this.apply(root, ticks / 20.0f + delta);
    }

    public double getRunningSeconds(class_7094 state, float progress, float speedMultiplier) {
        state.method_43686(progress, speedMultiplier);
        return this.getRunningSeconds(state);
    }

    public double getRunningSeconds(class_7094 state) {
        float f = (float)state.method_43687() / 1000.0f;
        double seconds = this.shouldLoop ? (double)f % this.animationLength : (double)f;
        return seconds;
    }

    public boolean isFinished(class_7094 state) {
        if (this.shouldLoop) {
            return false;
        }
        return this.getRunningSeconds(state) >= this.animationLength;
    }

    public void resetBones(class_630 root, boolean resetAll) {
        if (resetAll) {
            root.method_32088().forEach(class_630::method_41923);
            return;
        }
        this.boneTimelines.forEach((boneName, timeline) -> {
            try {
                if (IGNORED_BONES.contains(boneName.toLowerCase())) {
                    return;
                }
                class_630 bone = root.method_32088().filter(part -> part.method_41919(boneName)).findFirst().map(part -> part.method_32086(boneName)).orElse(null);
                if (bone == null) {
                    if (ROOT_BONES.contains(boneName.toLowerCase())) {
                        bone = root;
                    } else {
                        throw new IllegalStateException("Bone " + boneName + " not found in model. If this is the root part, ensure it is named 'root'.");
                    }
                }
                bone.method_32088().forEach(class_630::method_41923);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public class_3545<Float, Float> getRotations(String part, float progress) {
        if (!this.boneTimelines.containsKey(part)) {
            return new class_3545((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        class_243 rotation = this.boneTimelines.get(part).rotation().resolve(progress);
        return BedrockAnimation.eulerToPitchYaw(rotation);
    }

    public static class_3545<Float, Float> eulerToPitchYaw(class_243 rotation) {
        double xRad = Math.toRadians(rotation.field_1352);
        double yRad = Math.toRadians(rotation.field_1351);
        double zRad = Math.toRadians(rotation.field_1350);
        class_243 vec = new class_243(0.0, 0.0, 1.0);
        vec = new class_243(vec.field_1352, vec.field_1351 * Math.cos(xRad) - vec.field_1350 * Math.sin(xRad), vec.field_1351 * Math.sin(xRad) + vec.field_1350 * Math.cos(xRad));
        vec = new class_243(vec.field_1352 * Math.cos(yRad) + vec.field_1350 * Math.sin(yRad), vec.field_1351, -vec.field_1352 * Math.sin(yRad) + vec.field_1350 * Math.cos(yRad));
        vec = new class_243(vec.field_1352 * Math.cos(zRad) - vec.field_1351 * Math.sin(zRad), vec.field_1352 * Math.sin(zRad) + vec.field_1351 * Math.cos(zRad), vec.field_1350);
        float animYaw = (float)Math.toDegrees(Math.atan2(-vec.field_1352, vec.field_1350));
        float animPitch = (float)Math.toDegrees(Math.asin(-vec.field_1351 / vec.method_1033()));
        return new class_3545((Object)Float.valueOf(animPitch), (Object)Float.valueOf(animYaw));
    }

    @Generated
    public BedrockAnimation(boolean shouldLoop, double animationLength, Map<String, BoneTimeline> boneTimelines, boolean overrideBones, AnimationMetadata metadata, Map<Double, class_2960> sounds, String name) {
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.boneTimelines = boneTimelines;
        this.overrideBones = overrideBones;
        this.metadata = metadata;
        this.sounds = sounds;
        this.name = name;
    }

    @Generated
    public BedrockAnimation(boolean shouldLoop, double animationLength, Map<String, BoneTimeline> boneTimelines, boolean overrideBones, AnimationMetadata metadata, Map<Double, class_2960> sounds) {
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.boneTimelines = boneTimelines;
        this.overrideBones = overrideBones;
        this.metadata = metadata;
        this.sounds = sounds;
    }

    public record BoneTimeline(BoneValue position, BoneValue rotation, BoneValue scale) {
    }

    public static interface BoneValue {
        public class_243 resolve(double var1);

        public boolean isEmpty();
    }

    public static enum Transformation {
        POSITION,
        ROTATION,
        SCALE;

    }

    public static enum InterpolationType {
        SMOOTH,
        LINEAR;

    }

    public static class JumpKeyFrame
    extends KeyFrame {
        private final BoneValue pre;
        private final BoneValue post;

        public JumpKeyFrame(double time, Transformation transformation, InterpolationType interpolationType, BoneValue pre, BoneValue post) {
            super(time, transformation, interpolationType);
            this.pre = pre;
            this.post = post;
        }

        @Override
        public BoneValue getPre() {
            return this.pre;
        }

        @Override
        public BoneValue getPost() {
            return this.post;
        }
    }

    public static class SimpleKeyFrame
    extends KeyFrame {
        public final BoneValue data;

        public SimpleKeyFrame(double time, Transformation transformation, InterpolationType interpolationType, BoneValue data) {
            super(time, transformation, interpolationType);
            this.data = data;
        }

        @Override
        public BoneValue getPre() {
            return this.data;
        }

        @Override
        public BoneValue getPost() {
            return this.data;
        }
    }

    public static abstract class KeyFrame {
        public final double time;
        public final Transformation transformation;
        public final InterpolationType interpolationType;

        public KeyFrame(double time, Transformation transformation, InterpolationType interpolationType) {
            this.time = time;
            this.transformation = transformation;
            this.interpolationType = interpolationType;
        }

        public abstract BoneValue getPre();

        public abstract BoneValue getPost();
    }

    public static class EmptyBoneValue
    implements BoneValue {
        public static final EmptyBoneValue INSTANCE = new EmptyBoneValue();

        private EmptyBoneValue() {
        }

        @Override
        public class_243 resolve(double time) {
            return class_243.field_1353;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static class KeyFrameBoneValue
    extends TreeMap<Double, KeyFrame>
    implements BoneValue {
        private KeyFrame getAtIndex(SortedMap<Double, KeyFrame> map, Integer index) {
            if (index == null) {
                return null;
            }
            if (index < 0 || index >= map.size()) {
                return null;
            }
            Double key = new ArrayList<Double>(map.keySet()).get(index);
            return (KeyFrame)map.get(key);
        }

        @Override
        public class_243 resolve(double time) {
            class_243 beforeData;
            ArrayList keyList = new ArrayList(this.keySet());
            Integer afterIndex = null;
            for (int i = 0; i < keyList.size(); ++i) {
                if (!((Double)keyList.get(i) > time)) continue;
                afterIndex = i;
                break;
            }
            Integer beforeIndex = afterIndex == null ? Integer.valueOf(this.size() - 1) : (afterIndex == 0 ? null : Integer.valueOf(afterIndex - 1));
            KeyFrame after = this.getAtIndex(this, afterIndex);
            KeyFrame before = this.getAtIndex(this, beforeIndex);
            class_243 afterData = after != null && after.getPre() != null ? after.getPre().resolve(time) : class_243.field_1353;
            class_243 class_2432 = beforeData = before != null && before.getPost() != null ? before.getPost().resolve(time) : class_243.field_1353;
            if (before != null || after != null) {
                boolean smoothAfter;
                boolean smoothBefore = before != null && before.interpolationType == InterpolationType.SMOOTH;
                boolean bl = smoothAfter = after != null && after.interpolationType == InterpolationType.SMOOTH;
                if (smoothBefore || smoothAfter) {
                    if (before != null && after != null) {
                        Integer beforePlusIndex = beforeIndex == 0 ? null : Integer.valueOf(beforeIndex - 1);
                        KeyFrame beforePlus = this.getAtIndex(this, beforePlusIndex);
                        Integer afterPlusIndex = afterIndex == this.size() - 1 ? null : Integer.valueOf(afterIndex + 1);
                        KeyFrame afterPlus = this.getAtIndex(this, afterPlusIndex);
                        class_243 beforePlusData = beforePlus != null && beforePlus.getPost() != null ? beforePlus.getPost().resolve(time) : beforeData;
                        class_243 afterPlusData = afterPlus != null && afterPlus.getPre() != null ? afterPlus.getPre().resolve(time) : afterData;
                        double t = (time - before.time) / (after.time - before.time);
                        return new class_243((double)class_3532.method_41303((float)((float)t), (float)((float)beforePlusData.field_1352), (float)((float)beforeData.field_1352), (float)((float)afterData.field_1352), (float)((float)afterPlusData.field_1352)), (double)class_3532.method_41303((float)((float)t), (float)((float)beforePlusData.field_1351), (float)((float)beforeData.field_1351), (float)((float)afterData.field_1351), (float)((float)afterPlusData.field_1351)), (double)class_3532.method_41303((float)((float)t), (float)((float)beforePlusData.field_1350), (float)((float)beforeData.field_1350), (float)((float)afterData.field_1350), (float)((float)afterPlusData.field_1350)));
                    }
                    if (before != null) {
                        return beforeData;
                    }
                    return afterData;
                }
                if (before != null && after != null) {
                    double alpha = time;
                    alpha = (alpha - before.time) / (after.time - before.time);
                    return new class_243(beforeData.method_10216() + (afterData.method_10216() - beforeData.method_10216()) * alpha, beforeData.method_10214() + (afterData.method_10214() - beforeData.method_10214()) * alpha, beforeData.method_10215() + (afterData.method_10215() - beforeData.method_10215()) * alpha);
                }
                if (before != null) {
                    return beforeData;
                }
                return afterData;
            }
            return new class_243(0.0, 0.0, 0.0);
        }
    }

    public static class SimpleBoneValue
    implements BoneValue {
        public final class_243 value;
        public final Transformation transformation;

        public SimpleBoneValue(class_243 value, Transformation transformation) {
            this.value = value.method_18805(1.0, transformation == Transformation.POSITION ? -1.0 : 1.0, 1.0);
            this.transformation = transformation;
        }

        @Override
        public class_243 resolve(double time) {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class Group {
        @SerializedName(value="format_version")
        public String version;
        public Map<String, BedrockAnimation> animations;
    }
}

