/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.amble.lib.animation.client.AnimationMetadata;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimationAdapter
implements JsonDeserializer<BedrockAnimation> {
    public static final BedrockAnimationAdapter INSTANCE = new BedrockAnimationAdapter();

    public BedrockAnimation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new IllegalStateException("animation json could not be parsed");
        }
        JsonObject jsonObj = json.getAsJsonObject();
        double animationLength = jsonObj.has("animation_length") ? jsonObj.get("animation_length").getAsDouble() : -1.0;
        boolean shouldLoop = animationLength > 0.0 && jsonObj.has("loop") && jsonObj.get("loop").getAsBoolean();
        boolean overrideBones = jsonObj.has("override_previous_animation") && jsonObj.get("override_previous_animation").getAsBoolean();
        HashMap<String, BedrockAnimation.BoneTimeline> boneTimelines = new HashMap<String, BedrockAnimation.BoneTimeline>();
        if (jsonObj.has("bones")) {
            for (Map.Entry entry : jsonObj.getAsJsonObject("bones").entrySet()) {
                boneTimelines.put((String)entry.getKey(), this.deserializeBoneTimeline(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        }
        HashMap<Double, class_2960> sounds = null;
        if (jsonObj.has("sound_effects")) {
            sounds = new HashMap<Double, class_2960>();
            JsonObject soundObj = jsonObj.getAsJsonObject("sound_effects");
            for (String key : soundObj.keySet()) {
                String stringId;
                double time = BedrockAnimationAdapter.parseMath(key);
                if (time < 0.0 || time > animationLength || !soundObj.get(key).isJsonObject()) continue;
                JsonObject obj = soundObj.getAsJsonObject(key);
                if (obj.has("effect")) {
                    stringId = obj.get("effect").getAsString();
                } else {
                    if (!obj.has("locator")) continue;
                    stringId = obj.get("locator").getAsString();
                }
                class_2960 id = class_2960.method_12829((String)stringId);
                sounds.put(time, id);
            }
        }
        AnimationMetadata metadata = AnimationMetadata.DEFAULT;
        if (jsonObj.has("metadata")) {
            JsonObject jsonMetadata = jsonObj.getAsJsonObject("metadata");
            if (jsonMetadata.has("movement")) {
                metadata = metadata.withMovement(jsonMetadata.get("movement").getAsBoolean());
                jsonMetadata.remove("movement");
            }
            try {
                if (jsonMetadata.has("perspective")) {
                    String perspectiveStr = jsonMetadata.get("perspective").getAsString();
                    AnimationMetadata.Perspective perspective = AnimationMetadata.Perspective.valueOf(perspectiveStr.toUpperCase());
                    metadata = metadata.withPerspective(perspective);
                }
                jsonMetadata.remove("perspective");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (jsonMetadata.has("fps_camera")) {
                metadata = metadata.withFpsCamera(jsonMetadata.get("fps_camera").getAsBoolean());
                jsonMetadata.remove("fps_camera");
            }
            if (jsonMetadata.has("hide_hand_items")) {
                metadata = metadata.withHideHandItems(jsonMetadata.get("hide_hand_items").getAsBoolean());
                jsonMetadata.remove("hide_hand_items");
            }
            if (jsonMetadata.has("hide_hud")) {
                metadata = metadata.withHideHud(jsonMetadata.get("hide_hud").getAsBoolean());
                jsonMetadata.remove("hide_hud");
            }
            if (jsonMetadata.has("camera_uses_head")) {
                metadata = metadata.withFpsCameraCopiesHead(jsonMetadata.get("camera_uses_head").getAsBoolean());
                jsonMetadata.remove("camera_uses_head");
            }
            metadata = metadata.withExcess(jsonMetadata);
        }
        return new BedrockAnimation(shouldLoop, animationLength, boneTimelines, overrideBones, metadata, sounds);
    }

    private BedrockAnimation.BoneTimeline deserializeBoneTimeline(JsonObject bone) {
        JsonArray array;
        BedrockAnimation.BoneValue positions = BedrockAnimation.EmptyBoneValue.INSTANCE;
        BedrockAnimation.BoneValue rotations = BedrockAnimation.EmptyBoneValue.INSTANCE;
        BedrockAnimation.BoneValue scale = BedrockAnimation.EmptyBoneValue.INSTANCE;
        if (bone.has("position")) {
            if (bone.get("position").isJsonObject()) {
                positions = this.deserializeKeyframe(bone.getAsJsonObject("position"), BedrockAnimation.Transformation.POSITION);
            } else if (bone.get("position").isJsonArray()) {
                array = bone.getAsJsonArray("position");
                positions = new BedrockAnimation.SimpleBoneValue(new class_243(BedrockAnimationAdapter.parseMath(array.get(0)), BedrockAnimationAdapter.parseMath(array.get(1)), BedrockAnimationAdapter.parseMath(array.get(2))), BedrockAnimation.Transformation.POSITION);
            }
        }
        if (bone.has("rotation")) {
            if (bone.get("rotation").isJsonObject()) {
                rotations = this.deserializeKeyframe(bone.getAsJsonObject("rotation"), BedrockAnimation.Transformation.ROTATION);
            } else if (bone.get("rotation").isJsonArray()) {
                array = bone.getAsJsonArray("rotation");
                rotations = new BedrockAnimation.SimpleBoneValue(new class_243(BedrockAnimationAdapter.parseMath(array.get(0)), BedrockAnimationAdapter.parseMath(array.get(1)), BedrockAnimationAdapter.parseMath(array.get(2))), BedrockAnimation.Transformation.ROTATION);
            }
        }
        if (bone.has("scale")) {
            JsonElement json = bone.get("scale");
            if (json.isJsonObject()) {
                scale = this.deserializeKeyframe(json.getAsJsonObject(), BedrockAnimation.Transformation.SCALE);
            } else if (json.isJsonArray()) {
                JsonArray array2 = json.getAsJsonArray();
                scale = new BedrockAnimation.SimpleBoneValue(new class_243(BedrockAnimationAdapter.parseMath(array2.get(0)), BedrockAnimationAdapter.parseMath(array2.get(1)), BedrockAnimationAdapter.parseMath(array2.get(2))), BedrockAnimation.Transformation.SCALE);
            }
        }
        return new BedrockAnimation.BoneTimeline(positions, rotations, scale);
    }

    private BedrockAnimation.KeyFrameBoneValue deserializeKeyframe(JsonObject frames, BedrockAnimation.Transformation transformation) {
        BedrockAnimation.KeyFrameBoneValue keyframes = new BedrockAnimation.KeyFrameBoneValue();
        for (Map.Entry entry : frames.entrySet()) {
            double time = Double.parseDouble((String)entry.getKey());
            JsonElement keyframeJson = (JsonElement)entry.getValue();
            if (keyframeJson.isJsonObject()) {
                BedrockAnimation.InterpolationType type;
                JsonObject kfObj = keyframeJson.getAsJsonObject();
                BedrockAnimation.InterpolationType interpolationType = type = "catmullrom".equals(kfObj.has("lerp_mode") ? kfObj.get("lerp_mode").getAsString() : "linear") ? BedrockAnimation.InterpolationType.SMOOTH : BedrockAnimation.InterpolationType.LINEAR;
                if (kfObj.has("post")) {
                    JsonElement post = kfObj.get("post");
                    keyframes.put(time, new BedrockAnimation.JumpKeyFrame(time, transformation, type, this.deserializeSimpleBoneValue(kfObj.has("pre") ? kfObj.getAsJsonArray("pre") : post.getAsJsonArray(), transformation), this.deserializeSimpleBoneValue(post.getAsJsonArray(), transformation)));
                    continue;
                }
                if (!kfObj.has("pre")) continue;
                JsonElement pre = kfObj.get("pre");
                keyframes.put(time, new BedrockAnimation.JumpKeyFrame(time, transformation, type, this.deserializeSimpleBoneValue(pre.getAsJsonArray(), transformation), this.deserializeSimpleBoneValue(kfObj.has("post") ? kfObj.getAsJsonArray("post") : pre.getAsJsonArray(), transformation)));
                continue;
            }
            keyframes.put(time, new BedrockAnimation.SimpleKeyFrame(time, transformation, BedrockAnimation.InterpolationType.LINEAR, this.deserializeSimpleBoneValue(keyframeJson.getAsJsonArray(), transformation)));
        }
        return keyframes;
    }

    private BedrockAnimation.SimpleBoneValue deserializeSimpleBoneValue(JsonArray array, BedrockAnimation.Transformation transformation) {
        return new BedrockAnimation.SimpleBoneValue(new class_243((double)BedrockAnimationAdapter.parseMath(String.valueOf(array.get(0))), (double)BedrockAnimationAdapter.parseMath(String.valueOf(array.get(1))), (double)BedrockAnimationAdapter.parseMath(String.valueOf(array.get(2)))), transformation);
    }

    public static float parseMath(String data) {
        Expression expression = new ExpressionBuilder(data).build();
        double result = expression.evaluate();
        return (float)result;
    }

    public static double parseMath(JsonElement data) {
        if (data.isJsonPrimitive() && data.getAsJsonPrimitive().isNumber()) {
            return data.getAsDouble();
        }
        if (data.isJsonPrimitive() && data.getAsJsonPrimitive().isString()) {
            return BedrockAnimationAdapter.parseMath(data.getAsString());
        }
        throw new IllegalArgumentException("Invalid math expression: " + String.valueOf(data));
    }
}

