/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.client.bedrock;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.client.ClientScheduler;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BedrockAnimationTracker {
    public final BedrockAnimation animation;
    private final Consumer<Runnable> ticker;
    private final boolean reversed;
    private int ticks;

    public BedrockAnimationTracker(BedrockAnimation animation, Consumer<Runnable> nextTick, boolean reversed) {
        this.animation = animation;
        this.ticker = nextTick;
        this.ticks = 0;
        this.reversed = reversed;
    }

    public BedrockAnimationTracker(BedrockAnimation animation, boolean reversed) {
        this(animation, BedrockAnimationTracker.getSchedulerTicker(true), reversed);
    }

    private static Consumer<Runnable> getSchedulerTicker(boolean isClient) {
        if (isClient) {
            return runnable -> ClientScheduler.get().runTaskLater(runnable, TimeUnit.TICKS, 1L);
        }
        return runnable -> Scheduler.get().runTaskLater(runnable, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, 1L);
    }

    public void start() {
        if (this.isDone()) {
            this.ticks = 0;
        }
        if (this.ticks != 0) {
            AmbleKit.LOGGER.error("Attempted to start a Bedrock Animation Tracker that is already running! {}", (Object)this);
            return;
        }
        this.tick();
    }

    private void tick() {
        ++this.ticks;
        if (this.isDone()) {
            return;
        }
        this.ticker.accept(this::tick);
    }

    public boolean isDone() {
        if (this.animation.shouldLoop) {
            return false;
        }
        return (double)this.ticks >= this.animation.animationLength * 20.0;
    }

    public boolean isStarted() {
        return this.ticks > 0;
    }

    public int getTicks() {
        if (this.reversed) {
            return (int)(this.animation.animationLength * 20.0 - (double)this.ticks);
        }
        return this.ticks;
    }
}

