/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.lib.skin.PlayerSkinTexturable;
import dev.amble.lib.skin.SkinData;
import dev.amble.lib.skin.SkinTracker;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

public class SetSkinCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"amblekit").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"skin").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9247((String)"clear").executes(SetSkinCommand::executeClear))).then(class_2170.method_9247((String)"slim").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slim", (ArgumentType)BoolArgumentType.bool()).executes(SetSkinCommand::executeSlim)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(SetSkinCommand::executeWithSlim))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(SetSkinCommand::execute))))));
    }

    private static int executeClear(CommandContext<class_2168> context) {
        PlayerSkinTexturable texturable;
        class_1297 entity;
        try {
            entity = class_2186.method_9313(context, (String)"target");
            if (!(entity instanceof PlayerSkinTexturable)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target is not a PlayerSkinTexturable"));
                return 0;
            }
            texturable = (PlayerSkinTexturable)entity;
        }
        catch (CommandSyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Target"));
            return 0;
        }
        SkinTracker.getInstance().removeSynced(texturable.method_5667());
        String username = entity.method_5820();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Cleared skin of " + username)), true);
        return 1;
    }

    private static int executeSlim(CommandContext<class_2168> context) {
        PlayerSkinTexturable texturable;
        class_1297 entity;
        boolean slim = BoolArgumentType.getBool(context, (String)"slim");
        try {
            entity = class_2186.method_9313(context, (String)"target");
            if (!(entity instanceof PlayerSkinTexturable)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target is not a PlayerSkinTexturable"));
                return 0;
            }
            texturable = (PlayerSkinTexturable)entity;
        }
        catch (CommandSyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Target"));
            return 0;
        }
        SkinData data = (SkinData)SkinTracker.getInstance().get(texturable.method_5667());
        if (data == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target is not disguised."));
            return 0;
        }
        data = data.withSlim(slim);
        SkinTracker.getInstance().putSynced(texturable.method_5667(), data);
        String username = entity.method_5820();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set slimness of " + username + " to " + slim)), true);
        return 1;
    }

    private static int execute(CommandContext<class_2168> context) {
        boolean isUrl;
        PlayerSkinTexturable texturable;
        class_1297 entity;
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            entity = class_2186.method_9313(context, (String)"target");
            if (!(entity instanceof PlayerSkinTexturable)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target is not a PlayerSkinTexturable"));
                return 0;
            }
            texturable = (PlayerSkinTexturable)entity;
        }
        catch (CommandSyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Target"));
            return 0;
        }
        boolean bl = isUrl = value.startsWith("http://") || value.startsWith("https://");
        if (isUrl) {
            SkinData data = SkinData.url(value, false);
            SkinTracker.getInstance().putSynced(texturable.method_5667(), data);
            String username = entity.method_5820();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set skin of " + username + " to " + value)), true);
            return 1;
        }
        SkinData.username(value, result -> {
            result.upload(entity.method_5667());
            String username = entity.method_5820();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set skin of " + username + " to " + value)), true);
        });
        return 1;
    }

    private static int executeWithSlim(CommandContext<class_2168> context) {
        PlayerSkinTexturable texturable;
        class_1297 entity;
        String value = StringArgumentType.getString(context, (String)"value");
        boolean slim = BoolArgumentType.getBool(context, (String)"slim");
        try {
            entity = class_2186.method_9313(context, (String)"target");
            if (!(entity instanceof PlayerSkinTexturable)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Target is not a PlayerSkinTexturable"));
                return 0;
            }
            texturable = (PlayerSkinTexturable)entity;
        }
        catch (CommandSyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid Target"));
            return 0;
        }
        boolean isUrl = value.startsWith("http://") || value.startsWith("https://");
        SkinData data = isUrl ? SkinData.url(value, false) : SkinData.username(value, slim);
        SkinTracker.getInstance().putSynced(texturable.method_5667(), data);
        String username = entity.method_5820();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set skin of " + username + " to " + value)), true);
        return 1;
    }
}

