/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.register.datapack;

import com.mojang.serialization.Codec;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.register.datapack.DatapackRegistry;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.io.InputStream;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public abstract class SimpleDatapackRegistry<T extends Identifiable>
extends DatapackRegistry<T>
implements SimpleSynchronousResourceReloadListener {
    private final Function<InputStream, T> deserializer;
    private final Codec<T> codec;
    protected final class_2960 packet;
    private final class_2960 name;
    private final boolean sync;

    public SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, class_2960 packet, class_2960 name, boolean sync) {
        this.deserializer = deserializer;
        this.codec = codec;
        this.packet = packet;
        this.name = name;
        this.sync = sync;
    }

    protected SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String packet, String name, boolean sync, String modid) {
        this(deserializer, codec, new class_2960(modid, "sync_" + packet), new class_2960(modid, name), sync);
    }

    protected SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String name, boolean sync, String modid) {
        this(deserializer, codec, name, name, sync, modid);
    }

    @Deprecated(forRemoval=true, since="1.0.11")
    protected SimpleDatapackRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String name) {
        this(deserializer, codec, name, name, true, "amblekit");
    }

    @Override
    public void onClientInit() {
        if (!this.sync) {
            return;
        }
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.packet, (client, handler, buf, responseSender) -> this.readFromServer(buf));
    }

    @Override
    public void onServerInit() {
    }

    @Override
    public void onCommonInit() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
        if (!this.sync) {
            return;
        }
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> this.syncToClient(player));
    }

    @Override
    public void syncToEveryone() {
        if (!this.sync || ServerLifecycleHooks.get() == null) {
            return;
        }
        super.syncToEveryone();
    }

    @Override
    public void syncToClient(class_3222 player) {
        if (!this.sync) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.REGISTRY.size());
        for (Identifiable schema : this.REGISTRY.values()) {
            buf.method_49395(this.codec, (Object)schema);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.packet, (class_2540)buf);
    }

    @Override
    public void readFromServer(class_2540 buf) {
        if (!this.sync) {
            return;
        }
        this.defaults();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.register((Identifiable)buf.method_49394(this.codec));
        }
        AmbleKit.LOGGER.info("Read {} {} from server", (Object)size, (Object)this.name);
    }

    protected abstract void defaults();

    protected T read(InputStream stream) {
        return (T)((Identifiable)this.deserializer.apply(stream));
    }

    public class_2960 getFabricId() {
        return this.name;
    }

    public void method_14491(class_3300 manager) {
        this.defaults();
        for (class_2960 id : manager.method_14488(this.name.method_12832(), filename -> filename.method_12832().endsWith(".json")).keySet()) {
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    T created = this.read(stream);
                    if (created == null) {
                        stream.close();
                        continue;
                    }
                    this.register(created);
                    AmbleKit.LOGGER.info("Loaded datapack {} {}", (Object)this.name, (Object)created.id().toString());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Error occurred while loading resource json {}", (Object)id.toString(), (Object)e);
            }
        }
        this.syncToEveryone();
    }
}

