/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.skin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.amble.lib.AmbleKit;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.function.Consumer;

public class SkinConstants {
    public static final String SKIN_URL = "https://mineskin.eu/skin/";

    public static String encodeURL(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fetchPlayerModel(String name, Consumer<Boolean> slimConsumer) {
        new Thread(() -> {
            try {
                JsonObject metadata;
                JsonObject skin;
                JsonObject textures;
                HttpClient httpClient = HttpClient.newHttpClient();
                HttpRequest uuidRequest = HttpRequest.newBuilder(URI.create("https://api.mojang.com/users/profiles/minecraft/" + name)).build();
                HttpResponse<String> uuidResponse = httpClient.send(uuidRequest, HttpResponse.BodyHandlers.ofString());
                JsonObject uuidJson = JsonParser.parseString((String)uuidResponse.body()).getAsJsonObject();
                if (!uuidJson.has("id")) {
                    slimConsumer.accept(false);
                    return;
                }
                String uuid = uuidJson.get("id").getAsString();
                HttpRequest profileRequest = HttpRequest.newBuilder(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid)).build();
                HttpResponse<String> profileResponse = httpClient.send(profileRequest, HttpResponse.BodyHandlers.ofString());
                JsonObject json = JsonParser.parseString((String)profileResponse.body()).getAsJsonObject();
                String base64 = json.getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
                String decodedJson = new String(Base64.getDecoder().decode(base64));
                JsonObject decoded = JsonParser.parseString((String)decodedJson).getAsJsonObject();
                String model = "unknown";
                if (decoded.has("textures") && (textures = decoded.getAsJsonObject("textures")).has("SKIN") && (skin = textures.getAsJsonObject("SKIN")).has("metadata") && (metadata = skin.getAsJsonObject("metadata")).has("model")) {
                    model = metadata.get("model").getAsString();
                }
                AmbleKit.LOGGER.info("Fetched model for {}: {}", (Object)name, (Object)model);
                slimConsumer.accept(model.equalsIgnoreCase("slim"));
                return;
            }
            catch (IOException | InterruptedException e) {
                AmbleKit.LOGGER.error(String.valueOf(e));
                slimConsumer.accept(false);
                return;
            }
        }, "amblekit-ModelFetch").start();
    }
}

