/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.skin;

import dev.amble.lib.skin.PlayerSkinTexturable;
import dev.amble.lib.skin.SkinConstants;
import dev.amble.lib.skin.SkinTracker;
import dev.amble.lib.skin.client.SkinGrabber;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public record SkinData(String key, @Nullable String url, @Nullable class_2960 localTexture, boolean slim) {
    private static final SkinData CLEAR = new SkinData("supersecretcodeword", null, null, false);

    public static SkinData username(String username, boolean slim) {
        return new SkinData(username, "https://mineskin.eu/skin/" + username, null, slim);
    }

    public static void username(String username, Consumer<SkinData> consumer) {
        SkinConstants.fetchPlayerModel(username, slim -> consumer.accept(SkinData.username(username, slim)));
    }

    public static void usernameUpload(String username, UUID uuid) {
        SkinData.username(username, skin -> skin.upload(uuid));
    }

    public static SkinData url(String url, boolean slim) {
        return new SkinData(SkinConstants.encodeURL(url), url, null, slim);
    }

    public static SkinData texture(class_2960 texture, boolean slim) {
        return new SkinData(texture.toString(), null, texture, slim);
    }

    public static SkinData clear() {
        return CLEAR;
    }

    public static SkinData readBuf(class_2540 buf) {
        String key = buf.method_19772();
        String url = buf.readBoolean() ? buf.method_19772() : null;
        class_2960 localTexture = buf.readBoolean() ? buf.method_10810() : null;
        boolean slim = buf.readBoolean();
        if (key.equalsIgnoreCase(CLEAR.key())) {
            return null;
        }
        return new SkinData(key, url, localTexture, slim);
    }

    public void writeBuf(class_2540 buf) {
        buf.method_10814(this.key);
        buf.writeBoolean(this.url != null);
        if (this.url != null) {
            buf.method_10814(this.url);
        }
        buf.writeBoolean(this.localTexture != null);
        if (this.localTexture != null) {
            buf.method_10812(this.localTexture);
        }
        buf.writeBoolean(this.slim);
    }

    public SkinData withSlim(boolean slim) {
        return new SkinData(this.key, this.url, this.localTexture, slim);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2960 get() {
        if (this.localTexture != null) {
            return this.localTexture;
        }
        SkinGrabber grabber = SkinGrabber.INSTANCE;
        if (this.url == null) {
            return grabber.getPossibleSkin(this.key).orElse(null);
        }
        return grabber.getSkinOrDownload(this.key, this.url);
    }

    public void upload(UUID uuid) {
        SkinTracker.getInstance().putSynced(uuid, this);
    }

    public void upload(class_3222 player) {
        this.upload(player.method_5667());
    }

    public void upload(PlayerSkinTexturable player) {
        this.upload(player.method_5667());
    }
}

