/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.util;

public class StringCursor {
    private final String str;
    private int cursor;
    private final int step;

    public StringCursor(String str, int start, int step) {
        this.str = str;
        this.cursor = start;
        this.step = step;
    }

    public void next() {
        this.cursor += this.step;
    }

    public char peek() {
        return this.str.charAt(this.cursor);
    }

    public char peekNext() {
        return this.str.charAt(this.cursor + this.step);
    }

    public String substring() {
        if (this.step > 0) {
            if (this.cursor == 0) {
                return null;
            }
            return this.str.substring(this.cursor);
        }
        if (this.step < 0) {
            if (this.cursor + 1 == this.str.length()) {
                return null;
            }
            return this.str.substring(0, this.cursor + 1);
        }
        return null;
    }
}

