/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.yaar.behavior;

import dev.drtheo.yaar.behavior.Resolve;
import dev.drtheo.yaar.behavior.TBehavior;
import dev.drtheo.yaar.event.TEvents;
import dev.drtheo.yaar.event.TEventsRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;

public class TBehaviorRegistry {
    private static boolean frozen;
    private static final Set<TBehavior> handlers;

    @Contract(pure=true)
    public static void register(TBehavior behavior) {
        if (frozen) {
            throw new IllegalStateException("Registry already frozen!");
        }
        if (!TEventsRegistry.isFrozen()) {
            throw new IllegalStateException("Events registry was not frozen yet!");
        }
        handlers.add(behavior);
        TBehaviorRegistry.buildEvents(behavior);
    }

    @Contract(pure=true)
    public static void register(Supplier<TBehavior> behavior) {
        TBehaviorRegistry.register(behavior.get());
    }

    @Contract(pure=true)
    public static void freeze() {
        frozen = true;
        HashMap lookup = new HashMap();
        for (TBehavior handler : handlers) {
            lookup.put(handler.getClass(), handler);
        }
        for (TBehavior handler : handlers) {
            Class<?> clazz = handler.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                Resolve resolve;
                field.setAccessible(true);
                if (!Modifier.isFinal(field.getModifiers()) || (resolve = field.getAnnotation(Resolve.class)) == null) continue;
                Class<?> target = field.getType();
                try {
                    field.set(handler, lookup.get(target));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void buildEvents(TBehavior handler) {
        for (TEvents.BaseType<?> holder : TEventsRegistry.registered()) {
            if (!holder.isApplicable(handler)) continue;
            holder.subscribe(handler);
        }
    }

    static {
        handlers = Collections.newSetFromMap(new IdentityHashMap());
    }
}

