/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.yaar.event;

import dev.drtheo.yaar.event.TEvents;
import dev.drtheo.yaar.event.TEventsRegistry;
import dev.drtheo.yaar.state.StateResolveError;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;

public interface TEvent<T extends TEvents> {
    @Contract(pure=true)
    public TEvents.BaseType<T> type();

    public void handleAll(Iterable<T> var1);

    public static void handleSilent(TEvent<?> event, TEvents handler, Runnable r) {
        try {
            r.run();
        }
        catch (StateResolveError stateResolveError) {
        }
        catch (Throwable e) {
            TEventsRegistry.LOGGER.error("Failed to handle event '{}' for handler '{}'", new Object[]{event.getClass(), handler.getClass(), e});
        }
    }

    public static <R> R handleSilent(TEvent<?> event, TEvents handler, Supplier<R> s, Supplier<R> def) {
        try {
            return s.get();
        }
        catch (StateResolveError stateResolveError) {
        }
        catch (Throwable e) {
            TEventsRegistry.LOGGER.error("Failed to handle event '{}' for handler '{}'", new Object[]{event.getClass(), handler.getClass(), e});
        }
        return def.get();
    }

    public static <R> R handleSilent(TEvent<?> event, TEvents handler, Supplier<R> s, R def) {
        return (R)TEvent.handleSilent(event, handler, s, () -> def);
    }

    public static interface Result<T extends TEvents, R>
    extends TEvent<T> {
        public R result();

        @Override
        public void handleAll(Iterable<T> var1);
    }

    public static interface Notify<T extends TEvents>
    extends TEvent<T> {
        public void handle(T var1) throws StateResolveError;

        @Override
        default public void handleAll(Iterable<T> subscribed) {
            for (TEvents handler : subscribed) {
                TEvent.handleSilent(this, handler, () -> this.handle(handler));
            }
        }
    }
}

