/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.yaar.event;

import dev.drtheo.yaar.behavior.TBehavior;
import dev.drtheo.yaar.event.TEvent;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.Contract;

public interface TEvents {
    public static <T extends TEvents> void handle(TEvent<T> event) {
        event.type().handle(event);
    }

    public static <T extends TEvents, R> R handle(TEvent.Result<T, R> event) {
        event.type().handle(event);
        return event.result();
    }

    public static interface BaseType<T extends TEvents> {
        @Contract(pure=true)
        public boolean isApplicable(TBehavior var1);

        @Contract(pure=true)
        public void subscribe(TBehavior var1);

        public void handle(TEvent<T> var1);
    }

    public record Type<T extends TEvents>(Class<T> clazz, Deque<T> handlers) implements BaseType<T>
    {
        public Type(Class<T> clazz) {
            this(clazz, new ArrayDeque());
        }

        @Override
        @Contract(pure=true)
        public void subscribe(TBehavior behavior) {
            if (!this.isApplicable(behavior)) {
                throw new IllegalArgumentException("you're crazy");
            }
            this.handlers.add((TEvents)((Object)behavior));
        }

        @Override
        public void handle(TEvent<T> event) {
            event.handleAll(this.handlers);
        }

        @Override
        @Contract(pure=true)
        public boolean isApplicable(TBehavior behavior) {
            return this.clazz.isInstance(behavior);
        }
    }
}

