/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.yaar.state;

import dev.drtheo.yaar.state.TState;
import dev.drtheo.yaar.state.TStateContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;

public abstract class TAbstractStateRegistry {
    private boolean frozen;
    public static boolean debug;
    private final List<TState.Type<?>> comps = new ArrayList();
    private final Map<class_2960, TState.Type<?>> idToHolder = new HashMap();

    @Contract(pure=true)
    public TStateContainer createArrayHolder() {
        if (!this.frozen) {
            throw new IllegalStateException("Registry not frozen yet!");
        }
        return new TStateContainer.ArrayBacked(this.comps.size());
    }

    public void register(TState.Type<?> type) {
        if (this.frozen) {
            throw new IllegalStateException("Registry already frozen");
        }
        type.index = this.comps.size();
        this.comps.add(type);
        this.idToHolder.put(type.id(), type);
    }

    @Contract(pure=true)
    public TState.Type<?> get(int index) {
        return this.comps.get(index);
    }

    @Contract(pure=true)
    public TState.Type<?> get(class_2960 id) {
        return this.idToHolder.get(id);
    }

    @Contract(pure=true)
    public int size() {
        return this.comps.size();
    }

    @Contract(pure=true)
    public void freeze() {
        this.frozen = true;
    }
}

