/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.yaar.state;

import dev.drtheo.yaar.event.TEventsRegistry;
import dev.drtheo.yaar.state.NbtDeserializer;
import dev.drtheo.yaar.state.NbtSerializer;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface TState<Self extends TState<Self>> {
    @Contract(pure=true)
    public Type<Self> type();

    public static class Type<T extends TState<T>> {
        protected int index = -1;
        @NotNull
        protected final class_2960 id;

        @Contract(pure=true)
        public Type(@NotNull class_2960 id) {
            this.id = id;
        }

        @Contract(pure=true)
        @NotNull
        public class_2960 id() {
            return this.id;
        }

        @Contract(pure=true)
        public int verifyIndex() {
            if (this.index < 0) {
                throw new IllegalStateException("State " + String.valueOf(this.id) + " is not registered!");
            }
            return this.index;
        }

        public String toString() {
            return "Type{index=" + this.index + ", id=" + String.valueOf(this.id) + "}";
        }

        public int hashCode() {
            return this.index;
        }
    }

    public static abstract class SerializableType<T extends TState<T>, S>
    extends Type<T> {
        @Contract(pure=true)
        public SerializableType(@NotNull class_2960 id) {
            super(id);
        }

        @Contract(pure=true)
        @NotNull
        public abstract T decode(@NotNull S var1, boolean var2);

        @Contract(pure=true)
        @NotNull
        public abstract S encode(@NotNull T var1, boolean var2);
    }

    public static abstract class NbtBacked<T extends TState<T> & NbtSerializer>
    extends SerializableType<T, class_2487>
    implements NbtDeserializer<T> {
        @Contract(pure=true)
        public NbtBacked(@NotNull class_2960 id) {
            super(id);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public class_2487 encode(@NotNull T t, boolean isClient) {
            class_2487 nbt = new class_2487();
            ((NbtSerializer)t).toNbt(nbt, isClient);
            return nbt;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public T decode(@NotNull class_2487 element, boolean isClient) {
            try {
                return (T)((TState)this.fromNbt(element, isClient));
            }
            catch (Exception e) {
                TEventsRegistry.LOGGER.info(element.toString());
                throw e;
            }
        }
    }
}

