/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.yaar.state;

import dev.drtheo.yaar.state.StateResolveError;
import dev.drtheo.yaar.state.TState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TStateContainer {
    @Contract(pure=true)
    @Nullable
    public <T extends TState<T>> T stateOrNull(@NotNull TState.Type<T> var1);

    @Contract(pure=true)
    @NotNull
    default public <T extends TState<T>> T state(@NotNull TState.Type<T> type) {
        T result = this.stateOrNull(type);
        if (result == null) {
            throw StateResolveError.create(this, type);
        }
        return result;
    }

    @Contract(pure=true)
    default public <T extends TState<T>> T resolveState(@NotNull TState.Type<T> type) {
        T res = this.stateOrNull(type);
        if (res == null) {
            throw new IllegalStateException("Expected " + String.valueOf(type.id()));
        }
        return res;
    }

    @Contract(mutates="this")
    @Nullable
    public <T extends TState<T>> T removeState(@NotNull TState.Type<T> var1);

    @Contract(mutates="this")
    public boolean addState(@NotNull TState<?> var1);

    @Contract(pure=true)
    default public boolean hasState(@NotNull TState.Type<?> type) {
        return this.stateOrNull(type) != null;
    }

    @Contract(pure=true)
    public void forEachState(@NotNull Iterator var1);

    public static abstract class Delegate
    implements TStateContainer {
        private final TStateContainer parent;

        @Contract(pure=true)
        public Delegate(TStateContainer container) {
            this.parent = container;
        }

        @Override
        @Contract(pure=true)
        @Nullable
        public <T extends TState<T>> T stateOrNull(@NotNull TState.Type<T> type) {
            return this.parent.stateOrNull(type);
        }

        @Override
        @Contract(pure=true)
        public <T extends TState<T>> T resolveState(@NotNull TState.Type<T> type) {
            return this.parent.resolveState(type);
        }

        @Override
        @NotNull
        public <T extends TState<T>> T state(@NotNull TState.Type<T> type) {
            return this.parent.state(type);
        }

        @Override
        @Contract(mutates="this")
        @Nullable
        public <T extends TState<T>> T removeState(@NotNull TState.Type<T> type) {
            return this.parent.removeState(type);
        }

        @Override
        @Contract(mutates="this")
        public boolean addState(@NotNull TState<?> state) {
            return this.parent.addState(state);
        }

        @Override
        @Contract(pure=true)
        public void forEachState(@NotNull Iterator consumer) {
            this.parent.forEachState(consumer);
        }
    }

    public static class ArrayBacked
    implements TStateContainer {
        private static final Object REMOVED = new Object();
        private final Object[] data;

        @Contract(pure=true)
        protected ArrayBacked(int maxSize) {
            this.data = new Object[maxSize];
        }

        @Override
        @Contract(pure=true)
        @Nullable
        public <T extends TState<T>> T stateOrNull(@NotNull TState.Type<T> type) {
            int index = type.index;
            if (index < 0) {
                return null;
            }
            Object res = this.data[index];
            return (T)(res == REMOVED ? null : (TState)res);
        }

        @Override
        @Contract(mutates="this")
        @Nullable
        public <T extends TState<T>> T removeState(@NotNull TState.Type<T> type) {
            TState result = (TState)this.data[type.index];
            this.data[type.index] = REMOVED;
            return (T)result;
        }

        @Override
        @Contract(mutates="this")
        public boolean addState(@NotNull TState<?> state) {
            int index = state.type().verifyIndex();
            this.data[index] = state;
            return true;
        }

        @Override
        @Contract(pure=true)
        public void forEachState(@NotNull Iterator consumer) {
            Object[] objects = this.data;
            for (int i = 0; i < objects.length; ++i) {
                Object state = objects[i];
                if (state == null) continue;
                if (state == REMOVED) {
                    state = null;
                    objects[i] = null;
                }
                consumer.consume(i, (TState)state);
            }
        }
    }

    @FunctionalInterface
    public static interface Iterator {
        public void consume(int var1, @Nullable TState<?> var2);
    }
}

