/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api;

import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public interface GateShape {
    public static final GateShape EMPTY = new Const(List.of());
    public static final GateShape DEFAULT = GateShape.generated("_________\n_________\n___XXX___/\n__X___X__/\n_X_____X_//\n_X_____X_///\n_X_____X_////\n__X___X__\n___X_X___.\n");

    public void place(class_2680 var1, class_1937 var2, class_2338 var3, class_2350 var4);

    public void destroy(class_1937 var1, class_2338 var2, class_2350 var3);

    public boolean verify(class_2680 var1, class_1922 var2, class_2338 var3, class_2350 var4);

    public static GateShape generated(String shape) {
        return new GeneratedShape(shape).prepare();
    }

    public static class GeneratedShape
    extends Built {
        private final String shape;

        public GeneratedShape(String shape) {
            this.shape = shape;
        }

        @Override
        protected Iterable<class_2338> build() {
            HashSet<class_2338> ringPositions = new HashSet<class_2338>();
            List<String> list = this.shape.lines().toList();
            int height = list.size();
            int width = list.stream().mapToInt(String::length).max().orElse(0);
            int xOffset = width / 2;
            int yOffset = height / 2;
            for (int j = 0; j < height; ++j) {
                String line = list.get(j);
                for (int i = 0; i < line.length(); ++i) {
                    if (line.charAt(i) != 'X') continue;
                    ringPositions.add(new class_2338(i - xOffset + 2, yOffset - j + 4, 0));
                }
            }
            return ringPositions;
        }
    }

    public static class Const
    implements GateShape {
        private final Iterable<class_2338> built;

        public Const(Iterable<class_2338> built) {
            this.built = built;
        }

        @Override
        public void place(class_2680 state, class_1937 world, class_2338 corePos, class_2350 direction) {
            for (class_2338 pair : this.built) {
                class_2338 pos = Const.rotate(pair, corePos, direction);
                world.method_8501(pos, state);
            }
        }

        @Override
        public void destroy(class_1937 world, class_2338 corePos, class_2350 direction) {
            for (class_2338 pair : this.built) {
                class_2338 pos = Const.rotate(pair, corePos, direction);
                world.method_8650(pos, false);
            }
        }

        @Override
        public boolean verify(class_2680 state, class_1922 view, class_2338 corePos, class_2350 direction) {
            for (class_2338 pair : this.built) {
                class_2338 pos = Const.rotate(pair, corePos, direction);
                class_2680 placed = view.method_8320(pos);
                if (placed.method_26204() == state.method_26204()) continue;
                return false;
            }
            return true;
        }

        private static class_2338 rotate(class_2338 pos, class_2338 offset, class_2350 facing) {
            pos = Const.rotate(pos.method_10263(), pos.method_10264(), facing);
            return pos.method_10081((class_2382)offset);
        }

        public static class_2338 rotate(int x, int y, class_2350 facing) {
            return switch (facing) {
                case class_2350.field_11043 -> new class_2338(x, y, 0);
                case class_2350.field_11035 -> new class_2338(-x, y, 0);
                case class_2350.field_11039 -> new class_2338(0, y, x);
                case class_2350.field_11034 -> new class_2338(0, y, -x);
                default -> class_2338.field_10980;
            };
        }
    }

    public static abstract class Built {
        protected abstract Iterable<class_2338> build();

        protected GateShape prepare() {
            return new Const(this.build());
        }
    }
}

