/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api;

import dev.amble.stargate.StargateMod;
import dev.amble.stargate.api.GateKernelRegistry;
import dev.amble.stargate.api.StargateLike;
import dev.amble.stargate.api.data.StargateServerData;
import dev.amble.stargate.api.event.address.StargateRemoveEvent;
import dev.amble.stargate.api.event.init.StargateCreatedEvents;
import dev.amble.stargate.api.event.init.StargateLoadedEvents;
import dev.amble.stargate.api.event.init.StargateUpdateEvents;
import dev.amble.stargate.api.event.state.StateAddedEvent;
import dev.amble.stargate.api.event.state.StateRemovedEvent;
import dev.amble.stargate.api.event.tick.StargateTickEvent;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.api.state.address.GlobalAddressState;
import dev.amble.stargate.api.state.stargate.GateIdentityState;
import dev.amble.stargate.init.StargateBlocks;
import dev.amble.stargate.init.StargateYAARs;
import dev.amble.stargate.service.WorldProviderService;
import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;
import dev.drtheo.yaar.state.NbtSerializer;
import dev.drtheo.yaar.state.TState;
import dev.drtheo.yaar.state.TStateContainer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stargate
extends TStateContainer.Delegate
implements NbtSerializer,
StargateLike {
    private final class_5321<class_1937> dimension;
    private final class_2338 pos;
    private final class_2350 facing;
    private TState.Type<? extends GateState<?>> curState;
    private final boolean isClient;
    private boolean dirty;

    public Stargate(GateIdentityState identity, class_3218 world, class_2338 pos, class_2350 direction) {
        super(StargateYAARs.States.createArrayHolder());
        this.isClient = false;
        this.dimension = world.method_27983();
        this.pos = pos;
        this.facing = direction;
        identity.shape.place(StargateBlocks.RING.method_9564(), (class_1937)world, pos, direction);
        this.addState(identity);
        this.setGateState(this.fallbackGateState());
        StargateCreatedEvents.handleCreation(this);
    }

    public static Stargate fromNbt(class_2487 nbt, boolean isClient) {
        class_2960 id = new class_2960(nbt.method_10558("Id"));
        return ((GateKernelRegistry.Entry)GateKernelRegistry.get().method_10223(id)).load(nbt, isClient);
    }

    public Stargate(GateIdentityState identity, class_2487 nbt, boolean isClient) {
        super(StargateYAARs.States.createArrayHolder());
        this.isClient = isClient;
        class_2487 pos = nbt.method_10562("Pos");
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(pos.method_10558("dimension")));
        this.pos = class_2512.method_10691((class_2487)pos);
        this.facing = class_2350.method_10143((int)pos.method_10571("facing"));
        this.addState(identity);
        this.updateStates(nbt, isClient);
        StargateLoadedEvents.handleLoad(this);
    }

    public void tick() {
        TEvents.handle((TEvent)new StargateTickEvent(this));
    }

    public void remove() {
        class_3218 world = (class_3218)this.world();
        this.kernel().shape.destroy((class_1937)world, this.pos, this.facing);
        TEvents.handle((TEvent)new StargateRemoveEvent(StargateServerData.get(world), this));
    }

    @Override
    @NotNull
    public Stargate asGate() {
        return this;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public GateIdentityState kernel() {
        return (GateIdentityState)this.resolveState(GateIdentityState.state);
    }

    public long globalAddress() {
        return ((GlobalAddressState)this.resolveState(GlobalAddressState.state)).address();
    }

    public long globalId() {
        return ((GlobalAddressState)this.resolveState(GlobalAddressState.state)).getAsLong();
    }

    @NotNull
    public TState.Type<? extends GateState<?>> getGateStateType() {
        return this.curState;
    }

    @NotNull
    public GateState<?> getGateState() {
        return (GateState)this.stateOrNull(this.curState);
    }

    public void setGateState(GateState<?> state) {
        this.curState = state.type();
        this.addState(state);
    }

    public class_5321<class_1937> dimension() {
        return this.dimension;
    }

    @Nullable
    public class_1937 world() {
        return WorldProviderService.INSTANCE.getWorld(this.dimension, this.isClient);
    }

    public void playSound(class_3414 event) {
        this.world().method_45447(null, this.pos(), event, class_3419.field_15245);
    }

    public class_2338 pos() {
        return this.pos;
    }

    public class_2350 facing() {
        return this.facing;
    }

    public boolean dirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void unmarkDirty() {
        this.dirty = false;
    }

    public void updateStates(class_2487 nbt, boolean isClient) {
        class_2487 states = nbt.method_10562("States");
        for (String key : states.method_10541()) {
            TState.Type type = StargateYAARs.States.get(new class_2960(key));
            if (!(type instanceof TState.NbtBacked)) continue;
            TState.NbtBacked serializable = (TState.NbtBacked)type;
            class_2520 state = states.method_10580(key);
            if (state instanceof class_2487) {
                class_2487 compound = (class_2487)state;
                this.addState(serializable.decode(compound, isClient));
                continue;
            }
            this.removeState((TState.Type)serializable);
        }
        class_2960 prevStateId = new class_2960(nbt.method_10558("prevState"));
        TState.Type type = StargateYAARs.States.get(prevStateId);
        if (type == null || this.stateOrNull(type) == null) {
            StargateMod.LOGGER.warn("Bad state: '{}', fixing", (Object)prevStateId);
            this.setGateState(this.fallbackGateState());
            StargateUpdateEvents.handleUpdate(this);
            return;
        }
        StargateUpdateEvents.handleUpdate(this);
        this.curState = type;
    }

    private GateState<?> fallbackGateState() {
        return new GateState.Closed();
    }

    @Contract(mutates="this")
    public boolean addState(@NotNull TState<?> state) {
        boolean result = super.addState(state);
        if (result) {
            TEvents.handle((TEvent)new StateAddedEvent(this, state));
        }
        return result;
    }

    @Contract(mutates="this")
    @Nullable
    public <T extends TState<T>> T removeState(@NotNull TState.Type<T> type) {
        TState result = super.removeState(type);
        if (result != null) {
            TEvents.handle((TEvent)new StateRemovedEvent(this, result));
        }
        return (T)result;
    }

    public void toNbt(@NotNull class_2487 nbt, boolean isClient) {
        nbt.method_10582("Id", this.kernel().id.toString());
        class_2487 pos = class_2512.method_10692((class_2338)this.pos);
        pos.method_10582("dimension", this.dimension.method_29177().toString());
        pos.method_10567("facing", (byte)this.facing.method_10146());
        nbt.method_10566("Pos", (class_2520)pos);
        class_2487 states = new class_2487();
        this.forEachState((i, state) -> this.stateToNbt(states, i, state, isClient));
        nbt.method_10566("States", (class_2520)states);
        nbt.method_10582("prevState", this.curState.id().toString());
    }

    private <T extends TState<T>> void stateToNbt(class_2487 nbt, int i, @Nullable TState<T> state, boolean isClient) {
        if (state == null) {
            if (isClient) {
                nbt.method_10566(StargateYAARs.States.get(i).id().toString(), (class_2520)class_2481.field_21026);
            }
            return;
        }
        TState.Type type = state.type();
        if (!(type instanceof TState.NbtBacked)) {
            return;
        }
        TState.NbtBacked backed = (TState.NbtBacked)type;
        nbt.method_10566(type.id().toString(), (class_2520)backed.encode(state, isClient));
    }

    public int hashCode() {
        return this.pos.hashCode();
    }
}

