/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.address;

import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.address.GlyphOriginRegistry;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.security.SecureRandom;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class AddressProvider {
    static final int BITS_PER_COORD = AddressProvider.getBitsNeeded(Glyph.ALL.length);
    static final int MASK = (1 << BITS_PER_COORD) - 1;

    private static int getBitsNeeded(int max) {
        return class_3532.method_15384((double)(Math.log(max) / Math.log(2.0)));
    }

    private static int readAt(long address, int index) {
        int shift = index * BITS_PER_COORD;
        return (int)(address >> shift & (long)MASK) - 1;
    }

    private static long packI(int index, int value) {
        return AddressProvider.packI(index, (long)value);
    }

    private static long packI(int index, long value) {
        int shift = index * BITS_PER_COORD;
        return value + 1L << shift;
    }

    public static long pack(String address, int len) {
        char[] chars = address.toCharArray();
        int[] nums = new int[len];
        for (int i = 0; i < len; ++i) {
            nums[i] = Glyph.indexOf(chars[i]);
        }
        return AddressProvider.pack(nums, Glyph.ALL.length);
    }

    public static long pack(int[] numbers) {
        return AddressProvider.pack(numbers, Glyph.ALL.length);
    }

    public static int length(long address) {
        return (63 - Long.numberOfLeadingZeros(address)) / BITS_PER_COORD + 1;
    }

    public static String asString(long packed, int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = Glyph.ALL[AddressProvider.readAt(packed, i)];
        }
        return new String(chars);
    }

    public static long pack(int[] numbers, int k) {
        if (numbers.length == 0) {
            throw new IllegalArgumentException();
        }
        int maxPossible = (1 << BITS_PER_COORD) - 1;
        for (int num : numbers) {
            if (num < 0 || num > k) {
                throw new IllegalArgumentException("Number " + num + " is not in range [0, " + k + "]");
            }
            if (num <= maxPossible) continue;
            throw new IllegalArgumentException("Number " + num + " requires more than " + BITS_PER_COORD + " bits");
        }
        if ((long)numbers.length * (long)BITS_PER_COORD > 64L) {
            throw new IllegalArgumentException("Cannot pack " + numbers.length + " numbers with " + BITS_PER_COORD + " bits each in a single long (64 bits total)");
        }
        long packed = 0L;
        for (int i = 0; i < numbers.length; ++i) {
            packed |= AddressProvider.packI(i, numbers[i]);
        }
        return packed;
    }

    public static class Global
    extends AddressProvider {
        private static final SecureRandom RANDOM = new SecureRandom();
        static final int ID_MASK = (1 << BITS_PER_COORD * 8) - 1;

        public static long getId(long packed) {
            return packed & (long)ID_MASK;
        }

        public static char getTargetChar(long packed) {
            return Glyph.ALL[AddressProvider.readAt(packed, 8)];
        }

        public static class_5321<class_1937> getTarget(long packed) {
            return GlyphOriginRegistry.get().glyph(Global.getTargetChar(packed));
        }

        public static long generate(class_5321<class_1937> dim) {
            IntArraySet set = new IntArraySet();
            char poi = GlyphOriginRegistry.get().glyph(dim);
            int poiI = Glyph.indexOf(poi);
            while (set.size() != 8) {
                int a = RANDOM.nextInt(Glyph.ALL.length);
                if (a == poiI) continue;
                set.add(a);
            }
            long packed = Global.pack(set.toArray(new int[0]));
            return packed | AddressProvider.packI(8, poiI);
        }

        public static String asString(long packed) {
            return AddressProvider.asString(packed, 9);
        }
    }

    public static class Local
    extends AddressProvider {
        private static final SecureRandom RANDOM = new SecureRandom();
        static final int ID_MASK = (1 << BITS_PER_COORD * 6) - 1;

        public static long getId(long packed) {
            return packed & (long)ID_MASK;
        }

        public static char getTargetChar(long packed) {
            return Glyph.ALL[AddressProvider.readAt(packed, 6)];
        }

        public static class_5321<class_1937> getTarget(long packed) {
            return GlyphOriginRegistry.get().glyph(Local.getTargetChar(packed));
        }

        public static char getOriginChar(long packed) {
            return Glyph.ALL[AddressProvider.readAt(packed, Local.length(packed) - 1)];
        }

        public static long generate(class_5321<class_1937> world) {
            IntArraySet set = new IntArraySet();
            char poi = GlyphOriginRegistry.get().glyph(world);
            int poiI = Glyph.indexOf(poi);
            while (set.size() != 5) {
                int a = RANDOM.nextInt(Glyph.ALL.length);
                if (a == poiI) continue;
                set.add(a);
            }
            long packed = Local.pack(set.toArray(new int[0]));
            return packed | AddressProvider.packI(6, poiI);
        }
    }
}

