/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.address;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.lib.api.Identifiable;
import dev.amble.stargate.StargateMod;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7924;

public record Glyph(class_5321<class_1937> world, char glyph) implements Identifiable
{
    public static final Codec<Glyph> CODEC = class_5699.method_42114((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("dimension").forGetter(g -> g.world.method_29177()), (App)Codec.STRING.fieldOf("glyph").forGetter(symbol -> String.valueOf(symbol.glyph()))).apply((Applicative)instance, Glyph::new)));
    public static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ[]{}:;$()%";
    public static final char[] ALL = "ABCDEFGHIJKLMNOPQRSTUVWXYZ[]{}:;$()%".toCharArray();
    private static final class_2960 FONT_ID = StargateMod.id("stargate");
    private static final class_2583 STYLE = class_2583.field_24360.method_27704(FONT_ID);

    public Glyph(class_2960 dimension, String glyph) {
        this(dimension, glyph.charAt(0));
    }

    public Glyph(class_2960 dimension, char glyph) {
        this((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimension), glyph);
    }

    public Glyph(class_5321<class_1937> world, char glyph) {
        this.world = world;
        this.glyph = Glyph.validate(glyph);
    }

    @Deprecated(forRemoval=true)
    public static int indexOf(char c) {
        return ALPHABET.indexOf(c);
    }

    public static class_2561 asText(String s) {
        return class_2561.method_43470((String)s).method_10862(STYLE);
    }

    public static class_2561 asText(char c) {
        return class_2561.method_43470((String)String.valueOf(c)).method_10862(STYLE);
    }

    public static char validate(char input) {
        for (char c : ALL) {
            if (c != input) continue;
            return c;
        }
        return ALL[0];
    }

    public static Glyph fromInputStream(InputStream stream) {
        return Glyph.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static Glyph fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(planet -> created.set((Glyph)planet.getFirst())).ifRight(err -> {
            created.set(null);
            StargateMod.LOGGER.error("Error decoding datapack symbol: {}", err);
        });
        return (Glyph)created.get();
    }

    public class_2960 id() {
        return this.world.method_29177();
    }
}

