/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.behavior;

import dev.amble.lib.util.ServerLifecycleHooks;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.api.data.StargateServerData;
import dev.amble.stargate.api.event.address.AddressIdsListEvents;
import dev.amble.stargate.api.event.address.AddressResolveEvent;
import dev.amble.stargate.api.event.address.AddressResolveEvents;
import dev.amble.stargate.api.event.address.StargateRemoveEvents;
import dev.amble.stargate.api.event.init.StargateCreatedEvents;
import dev.amble.stargate.api.state.address.GlobalAddressState;
import dev.amble.stargate.api.state.address.LocalAddressState;
import dev.amble.stargate.api.state.stargate.C8Gates;
import dev.drtheo.yaar.behavior.TBehavior;
import dev.drtheo.yaar.behavior.TBehaviorRegistry;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public interface AddressBehaviors {
    public static void registerAll() {
        TBehaviorRegistry.register(C7::new);
        TBehaviorRegistry.register(C8::new);
        TBehaviorRegistry.register(C9::new);
        TBehaviorRegistry.register(LocalAddressBehavior::new);
        TBehaviorRegistry.register(GlobalAddressBehavior::new);
    }

    public static class C9
    implements TBehavior,
    AddressResolveEvents {
        @Override
        public AddressResolveEvent.Result resolve(Stargate stargate, long targetAddress, int length) {
            if (length != 9) {
                return AddressResolveEvent.PASS;
            }
            class_3218 world = ServerLifecycleHooks.get().method_3847(AddressProvider.Global.getTarget(targetAddress));
            if (world == null) {
                return AddressResolveEvent.FAIL;
            }
            Stargate target = StargateServerData.getOrCreate(world).getGlobal(targetAddress);
            if (target == null) {
                return AddressResolveEvent.FAIL;
            }
            float distance = class_3532.method_15355((float)((float)target.pos().method_10262((class_2382)target.pos())));
            long cost = 200000L + (long)class_3532.method_15375((float)(distance / 10.0f));
            return AddressResolveEvent.routeOrFail(target, 0L, cost);
        }
    }

    public static class C8
    implements TBehavior,
    AddressResolveEvents {
        public static final long COST_PT = 2000000L;

        @Override
        public AddressResolveEvent.Result resolve(Stargate stargate, long targetAddress, int length) {
            char targetChar;
            if (length != 8 || !(stargate.kernel() instanceof C8Gates)) {
                return AddressResolveEvent.PASS;
            }
            long ownAddress = ((LocalAddressState)stargate.state(LocalAddressState.state)).address();
            char originChar = AddressProvider.Local.getOriginChar(ownAddress);
            if (originChar != (targetChar = AddressProvider.Local.getOriginChar(targetAddress))) {
                return AddressResolveEvent.PASS;
            }
            class_3218 world = ServerLifecycleHooks.get().method_3847(AddressProvider.Local.getTarget(targetAddress));
            if (world == null) {
                return AddressResolveEvent.PASS;
            }
            Stargate target = StargateServerData.getOrCreate(world).getLocal(targetAddress);
            if (target == null || !(target.kernel() instanceof C8Gates)) {
                return AddressResolveEvent.FAIL;
            }
            return AddressResolveEvent.routeOrFail(target, 0L, 2000000L);
        }
    }

    public static class C7
    implements TBehavior,
    AddressResolveEvents {
        public static final long COST_PT = 200000L;

        @Override
        public AddressResolveEvent.Result resolve(Stargate stargate, long targetAddress, int length) {
            char targetChar;
            if (length != 7) {
                return AddressResolveEvent.PASS;
            }
            long ownAddress = ((LocalAddressState)stargate.state(LocalAddressState.state)).address();
            char originChar = AddressProvider.Local.getOriginChar(ownAddress);
            if (originChar != (targetChar = AddressProvider.Local.getOriginChar(targetAddress))) {
                return AddressResolveEvent.PASS;
            }
            class_3218 world = (class_3218)stargate.world();
            if (world == null) {
                return AddressResolveEvent.PASS;
            }
            Stargate target = StargateServerData.getOrCreate(world).getLocal(targetAddress);
            if (target == null || stargate.kernel().getClass() != target.kernel().getClass()) {
                return AddressResolveEvent.FAIL;
            }
            return AddressResolveEvent.route(target, 0L, 200000L);
        }
    }

    public static class GlobalAddressBehavior
    implements TBehavior,
    StargateRemoveEvents,
    StargateCreatedEvents,
    AddressIdsListEvents {
        @Override
        public void remove(StargateServerData data, Stargate stargate) {
            data.removeGlobal(stargate.globalAddress());
        }

        @Override
        public void onCreated(Stargate stargate) {
            StargateServerData data = StargateServerData.getOrCreate((class_3218)stargate.world());
            GlobalAddressState address = data.generateAddress(stargate.dimension(), stargate.pos(), GlobalAddressState::new);
            stargate.addState(address);
            data.addGlobal(address.address(), stargate);
        }

        @Override
        public long findAddressId(Stargate stargate) {
            return ((GlobalAddressState)stargate.state(GlobalAddressState.state)).getAsLong();
        }
    }

    public static class LocalAddressBehavior
    implements TBehavior,
    StargateRemoveEvents,
    StargateCreatedEvents,
    AddressIdsListEvents {
        @Override
        public void remove(StargateServerData data, Stargate stargate) {
            data.removeLocal(((LocalAddressState)stargate.state(LocalAddressState.state)).address());
        }

        @Override
        public void onCreated(Stargate stargate) {
            StargateServerData data = StargateServerData.getOrCreate((class_3218)stargate.world());
            LocalAddressState address = data.generateAddress(stargate.dimension(), stargate.pos(), LocalAddressState::new);
            stargate.addState(address);
            data.addLocal(address.address(), stargate);
        }

        @Override
        public long findAddressId(Stargate stargate) {
            return ((LocalAddressState)stargate.state(LocalAddressState.state)).getAsLong();
        }
    }
}

