/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.behavior;

import dev.amble.lib.block.behavior.horizontal.HorizontalBlockBehavior;
import dev.amble.lib.util.TeleportUtil;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.behavior.GateManagerBehavior;
import dev.amble.stargate.api.event.address.AddressResolveEvent;
import dev.amble.stargate.api.event.block.StargateBlockTickEvents;
import dev.amble.stargate.api.event.state.gate.StargateGateStateEvents;
import dev.amble.stargate.api.event.tick.StargateTickEvents;
import dev.amble.stargate.api.event.tp.StargateTpEvent;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.api.util.TeleportableEntity;
import dev.amble.stargate.block.entities.StargateBlockEntity;
import dev.amble.stargate.init.StargateSounds;
import dev.drtheo.yaar.behavior.Resolve;
import dev.drtheo.yaar.behavior.TBehavior;
import dev.drtheo.yaar.behavior.TBehaviorRegistry;
import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;
import dev.drtheo.yaar.event.impl.TriStateTEvent;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public interface GenericGateBehaviors {
    public static void registerAll() {
        TBehaviorRegistry.register(Closed::new);
        TBehaviorRegistry.register(Opening::new);
        TBehaviorRegistry.register(Open::new);
    }

    public static class Open
    implements TBehavior,
    StargateTickEvents,
    StargateBlockTickEvents,
    StargateGateStateEvents {
        @Resolve
        private final GateManagerBehavior manager = (GateManagerBehavior)this.behavior();

        @Override
        public void onStateChanged(Stargate stargate, GateState<?> oldState, GateState<?> newState) {
            if (oldState.gateState() == GateState.StateType.OPEN && newState.gateState() == GateState.StateType.CLOSED) {
                stargate.playSound(StargateSounds.GATE_CLOSE);
            }
        }

        @Override
        public void tick(Stargate stargate) {
            if (stargate.isClient()) {
                return;
            }
            GateState.Open open = (GateState.Open)stargate.state(GateState.Open.state);
            if (open.target == null) {
                this.manager.set(stargate, new GateState.Closed());
                return;
            }
            if (open.timer++ > 1200) {
                open.timer = 0;
                this.manager.set(stargate, new GateState.Closed());
                this.manager.set(open.target, new GateState.Closed());
            }
        }

        @Override
        public void block$randomDisplayTick(Stargate stargate, class_1937 world, class_2338 pos, class_2680 state, class_5819 random) {
            if (random.method_43048(100) < 5) {
                world.method_45447(null, pos, StargateSounds.WORMHOLE_LOOP, class_3419.field_15245);
            }
        }

        @Override
        public void block$tick(Stargate stargate, StargateBlockEntity entity, class_1937 world, class_2338 pos, class_2680 state) {
            if (world.method_8608()) {
                return;
            }
            if (world.method_8510() % 10L != 0L) {
                return;
            }
            class_2350 facing = HorizontalBlockBehavior.getFacing((class_2680)state);
            class_238 box = stargate.kernel().forDirection(facing).method_996(pos);
            GateState.Open open = (GateState.Open)stargate.state(GateState.Open.state);
            List entities = world.method_8333(null, box, e -> e.method_5805() && !e.method_7325());
            for (class_1297 e2 : entities) {
                if (!(e2 instanceof class_1309)) continue;
                class_1309 living = (class_1309)e2;
                this.tryTeleportFrom(stargate, open, living);
            }
        }

        public void tryTeleportFrom(Stargate stargate, GateState.Open open, class_1309 entity) {
            TeleportableEntity holder;
            if (!(entity instanceof TeleportableEntity) || (holder = (TeleportableEntity)entity).stargate$updateAndGetTicks(20) != 0) {
                return;
            }
            Stargate target = open.target;
            if (target == null) {
                return;
            }
            class_2338 targetBlockPos = target.pos();
            class_3218 targetWorld = (class_3218)target.world();
            if (targetWorld == null) {
                return;
            }
            TriStateTEvent.Result result = (TriStateTEvent.Result)TEvents.handle((TEvent.Result)new StargateTpEvent(stargate, target, entity));
            if (result == TriStateTEvent.Result.DENY) {
                return;
            }
            class_2338 pos = stargate.pos();
            class_243 offset = entity.method_19538().method_1020(pos.method_46558().method_1023(0.0, 0.5, 0.0));
            entity.method_37908().method_8396(null, pos, StargateSounds.GATE_TELEPORT, class_3419.field_15245, 1.0f, 1.0f);
            targetWorld.method_8396(null, targetBlockPos, StargateSounds.GATE_TELEPORT, class_3419.field_15245, 1.0f, 1.0f);
            class_243 velocity = entity.method_18798();
            class_243 direction = targetBlockPos.method_46558().method_1020(pos.method_46558()).method_1029();
            double speed = velocity.method_1033();
            class_243 newVelocity = direction.method_1021(speed);
            TeleportUtil.teleport((class_1309)entity, (class_3218)targetWorld, (class_243)targetBlockPos.method_46558().method_1019(offset), (float)target.facing().method_10144());
            entity.method_18799(newVelocity);
            holder.stargate$setTicks(20);
        }
    }

    public static class Opening
    implements TBehavior,
    StargateGateStateEvents,
    StargateTickEvents {
        static final float p0 = 0.0f;
        static final float p1 = 22.0f;
        static final float p2 = -12.0f;
        static final float p3 = 0.0f;
        @Resolve
        private final GateManagerBehavior manager = (GateManagerBehavior)this.behavior();

        @Override
        public void onStateChanged(Stargate stargate, GateState<?> oldState, GateState<?> newState) {
            if (newState.gateState() == GateState.StateType.OPENING) {
                stargate.playSound(StargateSounds.GATE_OPEN);
            }
        }

        @Override
        public void tick(Stargate stargate) {
            GateState.Opening opening = (GateState.Opening)stargate.state(GateState.Opening.state);
            float t = (float)opening.timer / 100.0f;
            float tPrime = class_3532.method_15363((float)((float)(3.0 * Math.pow(t, 2.0) - 2.0 * Math.pow(t, 3.0))), (float)0.0f, (float)1.0f);
            opening.kawooshHeight = (float)(Math.pow(1.0f - tPrime, 3.0) * 0.0 + 3.0 * Math.pow(1.0f - tPrime, 2.0) * (double)tPrime * 22.0 + (double)(3.0f * (1.0f - tPrime)) * Math.pow(tPrime, 2.0) * -12.0 + Math.pow(tPrime, 3.0) * 0.0);
            if (opening.timer++ <= 80 || tPrime != 1.0f) {
                return;
            }
            opening.kawooshHeight = 0.0f;
            opening.timer = 0;
            if (stargate.isClient()) {
                return;
            }
            if (opening.caller && opening.target != null) {
                this.manager.set(stargate, new GateState.Open(opening.target, true));
                this.manager.set(opening.target, new GateState.Open(stargate, false));
            } else {
                this.manager.set(stargate, new GateState.Closed());
            }
        }
    }

    public static class Closed
    implements TBehavior,
    StargateTickEvents {
        @Resolve
        private final GateManagerBehavior manager = (GateManagerBehavior)this.behavior();

        @Override
        public void tick(Stargate stargate) {
            GateState.Closed closed = (GateState.Closed)stargate.state(GateState.Closed.state);
            if (stargate.isClient()) {
                if (closed.locking) {
                    closed.timer = (closed.timer + 1) % Closed.calculateDelay(closed);
                }
                return;
            }
            int length = closed.address.length();
            boolean bl = closed.locking = length > closed.locked;
            if (length < closed.locked) {
                closed.locked = length;
                closed.timer = 0;
                stargate.markDirty();
                return;
            }
            if (!closed.locking || closed.timer++ < Closed.calculateDelay(closed)) {
                return;
            }
            closed.timer = 0;
            ++closed.locked;
            stargate.playSound(StargateSounds.CHEVRON_LOCK);
            stargate.markDirty();
            AddressResolveEvent.Result resolved = (AddressResolveEvent.Result)TEvents.handle((TEvent.Result)new AddressResolveEvent(stargate, closed.address, closed.locked));
            if (!(resolved instanceof AddressResolveEvent.Result.Route)) {
                if (resolved instanceof AddressResolveEvent.Result.Fail || closed.locked >= stargate.kernel().maxChevrons) {
                    this.fail(stargate);
                }
                return;
            }
            AddressResolveEvent.Result.Route route = (AddressResolveEvent.Result.Route)resolved;
            this.manager.set(stargate, new GateState.Opening(route.stargate(), true));
            this.manager.set(route.stargate(), new GateState.Opening(null, false));
            route.stargate().markDirty();
        }

        public static int calculateDelay(int curGlyph, int nextGlyph) {
            return Math.abs(nextGlyph - curGlyph) * 5;
        }

        public static int calculateDelay(GateState.Closed closed) {
            char curGlyph = closed.locked != 0 ? closed.address.charAt(closed.locked - 1) : (char)(Glyph.ALL.length / 2);
            char nextGlyph = closed.address.charAt(closed.locked);
            return Closed.calculateDelay(Glyph.indexOf(curGlyph), Glyph.indexOf(nextGlyph));
        }

        public void fail(Stargate stargate) {
            stargate.playSound(StargateSounds.GATE_FAIL);
            this.manager.set(stargate, new GateState.Closed());
        }
    }
}

