/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.behavior;

import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.event.block.StargateBlockTickEvents;
import dev.amble.stargate.api.event.block.StargateBlockUseEvents;
import dev.amble.stargate.api.event.init.StargateLoadedEvents;
import dev.amble.stargate.api.event.init.StargateUpdateEvents;
import dev.amble.stargate.api.event.tp.StargateTpEvents;
import dev.amble.stargate.api.state.iris.ClientIrisState;
import dev.amble.stargate.api.state.iris.IrisState;
import dev.amble.stargate.block.entities.StargateBlockEntity;
import dev.amble.stargate.init.StargateSounds;
import dev.drtheo.yaar.behavior.TBehavior;
import dev.drtheo.yaar.event.impl.TriStateTEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public class IrisBehavior
implements TBehavior,
StargateTpEvents,
StargateBlockTickEvents,
StargateLoadedEvents,
StargateUpdateEvents,
StargateBlockUseEvents {
    @Override
    public TriStateTEvent.Result onGateTp(Stargate from, Stargate to, class_1309 living) {
        boolean open = ((IrisState)to.state(IrisState.state)).open;
        if (open) {
            return TriStateTEvent.Result.PASS;
        }
        living.method_5643(to.world().method_48963().method_48822(), 2.1474836E9f);
        to.world().method_45447(null, to.pos(), StargateSounds.IRIS_HIT, class_3419.field_15245);
        return TriStateTEvent.Result.DENY;
    }

    @Override
    public void block$tick(Stargate stargate, StargateBlockEntity entity, class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        IrisState irisState = (IrisState)stargate.state(IrisState.state);
        boolean newState = irisState.open;
        if (irisState.prevIrisState != newState) {
            class_3414 sound = newState ? StargateSounds.IRIS_CLOSE : StargateSounds.IRIS_OPEN;
            world.method_45447(null, pos, sound, class_3419.field_15245);
            irisState.prevIrisState = newState;
            stargate.markDirty();
        }
    }

    @Override
    public void onLoaded(Stargate stargate) {
        this.checkAndAttach(stargate);
    }

    @Override
    public void onUpdate(Stargate stargate) {
        this.checkAndAttach(stargate);
    }

    private void checkAndAttach(Stargate stargate) {
        if (stargate.isClient() && stargate.hasState(IrisState.state) && !stargate.hasState(ClientIrisState.state)) {
            stargate.addState(new ClientIrisState());
        }
    }

    @Override
    public boolean onUse(Stargate stargate, StargateBlockEntity blockEntity, class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_1268 hand, class_3965 blockHit) {
        if (world.field_9236) {
            return false;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (!heldItem.method_7960()) {
            return false;
        }
        IrisState s = (IrisState)stargate.state(IrisState.state);
        s.open = !s.open;
        stargate.markDirty();
        return true;
    }
}

