/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.data;

import dev.amble.stargate.StargateMod;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.service.StargateDataProviderService;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StargateData {
    public static final class_2960 SYNC = StargateMod.id("sync");
    public static final class_2960 SYNC_ALL = StargateMod.id("sync_all");
    public static final class_2960 REMOVE = StargateMod.id("remove");

    @Nullable
    public static StargateData get(class_1937 world) {
        return StargateDataProviderService.INSTANCE.get(world);
    }

    public static void accept(class_1937 world, Consumer<StargateData> consumer) {
        StargateDataProviderService.INSTANCE.accept(world, consumer);
    }

    @Nullable
    public static <R> R apply(class_1937 world, Function<StargateData, R> func) {
        return StargateDataProviderService.INSTANCE.apply(world, func);
    }

    @NotNull
    public static StargateData getOrCreate(class_1937 world) {
        return StargateDataProviderService.INSTANCE.getOrCreate(world);
    }

    default public void removeLocal(long address) {
        this.removeId(AddressProvider.Local.getId(address));
    }

    default public void removeGlobal(long address) {
        this.removeId(AddressProvider.Global.getId(address));
    }

    default public void addLocal(long address, Stargate stargate) {
        this.addId(AddressProvider.Local.getId(address), stargate);
    }

    default public void addGlobal(long address, Stargate stargate) {
        this.addId(AddressProvider.Global.getId(address), stargate);
    }

    @Nullable
    default public Stargate getLocal(long address) {
        return this.getById(AddressProvider.Local.getId(address));
    }

    @Nullable
    default public Stargate getGlobal(long address) {
        return this.getById(AddressProvider.Global.getId(address));
    }

    public void addId(long var1, Stargate var3);

    public void removeId(long var1);

    public boolean containsId(long var1);

    @Nullable
    public Stargate getById(long var1);
}

