/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.data;

import dev.amble.lib.util.ServerLifecycleHooks;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.api.data.StargateData;
import dev.amble.stargate.api.data.StargateLinkable;
import dev.amble.stargate.api.data.StargateServerData;
import dev.amble.stargate.service.StargateDataProviderService;
import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class StargateRef
implements StargateLinkable {
    private final Supplier<class_1937> world;
    protected long address = -1L;
    @Nullable
    protected WeakReference<Stargate> stargate;

    public StargateRef(Supplier<class_1937> world) {
        this.world = world;
    }

    @Override
    @Nullable
    public Stargate asGate() {
        if (this.stargate != null) {
            return (Stargate)this.stargate.get();
        }
        if (this.address != -1L) {
            System.out.println("fallback for A=" + this.address + "; client? " + this.world.get().field_9236);
            Stargate found = StargateData.apply(this.world.get(), data -> data.getById(this.address));
            if (found != null) {
                System.out.println("found!");
                this.stargate = new WeakReference<Stargate>(found);
                return found;
            }
        }
        return null;
    }

    private boolean link(long id, @Nullable Stargate gate) {
        class_1937 class_19372;
        System.out.println("Linking: " + id + "/" + String.valueOf(gate) + ": client? " + this.world.get().field_9236);
        Stargate oldGate = this.asGate();
        this.stargate = gate != null ? new WeakReference<Stargate>(gate) : null;
        this.address = id;
        if (oldGate != this.asGate() && (class_19372 = this.world.get()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            StargateServerData data = StargateServerData.getOrCreate(serverWorld);
            if (oldGate != null) {
                data.unmark(oldGate);
            }
            if (this.isLinked()) {
                data.mark(this);
            }
        }
        return this.isLinked();
    }

    @Override
    public boolean link(@Nullable Stargate gate) {
        return this.link(gate != null ? gate.globalId() : -1L, gate);
    }

    @Override
    public boolean link(long address) {
        return this.link(address, null);
    }

    @Override
    public void unlink() {
        this.link(null);
    }

    public void readNbt(class_2487 nbt) {
        if (!nbt.method_10545("Stargate")) {
            return;
        }
        this.link(nbt.method_10537("Stargate"));
    }

    public void writeNbt(class_2487 nbt) {
        if (!this.isLinked()) {
            return;
        }
        nbt.method_10544("Stargate", this.address);
    }

    public long address() {
        return this.address;
    }

    @Nullable
    public static Stargate resolveGlobal(long globalAddress, boolean isClient) {
        if (globalAddress == -1L) {
            return null;
        }
        if (isClient) {
            return StargateDataProviderService.INSTANCE.getClient().getGlobal(globalAddress);
        }
        class_5321<class_1937> key = AddressProvider.Global.getTarget(globalAddress);
        class_3218 world = ServerLifecycleHooks.get().method_3847(key);
        if (world != null) {
            return StargateServerData.apply(world, data -> data.getGlobal(globalAddress));
        }
        return null;
    }
}

