/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.data;

import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.StargateLike;
import dev.amble.stargate.api.data.StargateData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateServerData
extends class_18
implements StargateData {
    private final Long2ObjectMap<Stargate> lookup = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<ReferenceSet<Stargate>> chunk2Gates = new Long2ObjectOpenHashMap();
    private final class_3218 world;

    public static void init() {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            StargateServerData data = StargateServerData.get(world);
            if (data != null) {
                data.tick();
            }
        });
        ServerPlayConnectionEvents.JOIN.register((networkHandler, packetSender, minecraftServer) -> {
            class_3222 player = networkHandler.field_14140;
            StargateServerData data = StargateServerData.get((class_3218)player.method_37908());
            if (data != null) {
                data.syncAll(List.of(networkHandler.field_14140));
            }
        });
    }

    private StargateServerData(class_3218 world) {
        this.world = world;
    }

    public void mark(StargateLike gateLike) {
        Stargate stargate = gateLike.asGate();
        if (stargate != null) {
            ((ReferenceSet)this.chunk2Gates.computeIfAbsent(class_1923.method_37232((class_2338)stargate.pos()), l -> new ReferenceOpenHashSet())).add((Object)stargate);
        }
    }

    public void unmark(StargateLike gateLike) {
        Stargate stargate = gateLike.asGate();
        if (stargate != null) {
            ((ReferenceSet)this.chunk2Gates.get(class_1923.method_37232((class_2338)stargate.pos()))).remove((Object)stargate);
        }
    }

    @Nullable
    public Collection<Stargate> findByChunk(int chunkX, int chunkZ) {
        return (Collection)this.chunk2Gates.get(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    private Collection<class_3222> tracking(Stargate stargate) {
        return PlayerLookup.tracking((class_3218)this.world, (class_2338)stargate.pos());
    }

    private void tick() {
        for (Stargate stargate : this.lookup.values()) {
            if (!this.world.method_39999(stargate.pos())) continue;
            stargate.tick();
            if (!stargate.dirty()) continue;
            this.syncPartial(stargate.globalId(), stargate, this.tracking(stargate));
            stargate.unmarkDirty();
        }
    }

    public boolean method_79() {
        return true;
    }

    public void syncAll(Collection<class_3222> targets) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10794(this.toNbt(true));
        targets.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC_ALL, (class_2540)buf));
    }

    public void syncPartial(long id, Stargate gate, Collection<class_3222> targets) {
        class_2487 nbt = new class_2487();
        gate.toNbt(nbt, true);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10791(id);
        buf.method_10794(nbt);
        targets.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC, (class_2540)buf));
    }

    private void removePartial(Stargate gate, Collection<class_3222> targets) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10791(gate.globalAddress());
        targets.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)REMOVE, (class_2540)buf));
    }

    public <R extends LongSupplier> R generateAddress(class_5321<class_1937> world, class_2338 pos, BiFunction<class_5321<class_1937>, class_2338, R> func) {
        LongSupplier address = null;
        while (address == null || this.containsId(address.getAsLong())) {
            address = (LongSupplier)func.apply(world, pos);
        }
        return (R)address;
    }

    @Override
    public void addId(long id, Stargate stargate) {
        this.lookup.put(id, (Object)stargate);
        this.syncPartial(id, stargate, this.tracking(stargate));
    }

    @Override
    public void removeId(long id) {
        Stargate stargate = (Stargate)this.lookup.remove(id);
        Collection meta = (Collection)this.chunk2Gates.get(class_1923.method_37232((class_2338)stargate.pos()));
        meta.remove(stargate);
        this.removePartial(stargate, this.tracking(stargate));
    }

    @Override
    public boolean containsId(long id) {
        return this.lookup.containsKey(id);
    }

    @Override
    @Nullable
    public Stargate getById(long id) {
        return (Stargate)this.lookup.get(id);
    }

    public class_2487 method_75(class_2487 nbt) {
        return this.toNbt(false);
    }

    private class_2487 toNbt(boolean sync) {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        this.lookup.values().forEach(stargate -> {
            class_2487 compound = new class_2487();
            stargate.toNbt(compound, sync);
            list.add((Object)compound);
        });
        nbt.method_10566("Network", (class_2520)list);
        return nbt;
    }

    public static StargateServerData loadNbt(class_3218 world, class_2487 nbt) {
        StargateServerData data = new StargateServerData(world);
        class_2499 network = nbt.method_10554("Network", 10);
        return data;
    }

    @NotNull
    public static StargateServerData getOrCreate(class_3218 world) {
        return (StargateServerData)world.method_17983().method_17924(nbt -> StargateServerData.loadNbt(world, nbt), () -> new StargateServerData(world), "stargate");
    }

    @Nullable
    public static StargateServerData get(class_3218 world) {
        return (StargateServerData)world.method_17983().method_20786(nbt -> StargateServerData.loadNbt(world, nbt), "stargate");
    }

    public static void accept(class_3218 world, Consumer<StargateServerData> consumer) {
        StargateServerData data = StargateServerData.get(world);
        if (data != null) {
            consumer.accept(data);
        }
    }

    @Nullable
    public static <R> R apply(class_3218 world, Function<StargateServerData, R> func) {
        StargateServerData data = StargateServerData.get(world);
        return data != null ? (R)func.apply(data) : null;
    }
}

