/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.event.address;

import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.api.event.address.AddressResolveEvents;
import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressResolveEvent
implements TEvent.Result<AddressResolveEvents, Result> {
    private final Stargate stargate;
    private final long address;
    private final int length;
    private Result result = PASS;
    public static final Result PASS = new Result.Pass();
    public static final Result FAIL = new Result.Fail();

    public AddressResolveEvent(Stargate stargate, String address, int length) {
        this.stargate = stargate;
        this.address = AddressProvider.pack(address, length);
        this.length = length;
    }

    public TEvents.BaseType<AddressResolveEvents> type() {
        return AddressResolveEvents.event;
    }

    public void handleAll(Iterable<AddressResolveEvents> subscribed) {
        for (AddressResolveEvents e : subscribed) {
            Result result = (Result)TEvent.handleSilent((TEvent)this, (TEvents)e, () -> e.resolve(this.stargate, this.address, this.length), (Object)PASS);
            if (result == PASS) continue;
            this.result = result;
            return;
        }
    }

    public Result result() {
        return this.result;
    }

    public static Result route(@NotNull Stargate stargate, long openCost, long costPerTick) {
        return new Result.Route(stargate, openCost, costPerTick);
    }

    public static Result routeOrFail(@Nullable Stargate stargate, long openCost, long costPerTick) {
        return stargate == null ? FAIL : AddressResolveEvent.route(stargate, openCost, costPerTick);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Result {

        public record Pass() implements Result
        {
        }

        public record Route(Stargate stargate, long openCost, long costPerTick) implements Result
        {
        }

        public record Fail() implements Result
        {
        }
    }
}

