/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.api.state;

import dev.amble.stargate.StargateMod;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.data.StargateRef;
import dev.amble.stargate.util.NbtUtil;
import dev.drtheo.yaar.state.NbtSerializer;
import dev.drtheo.yaar.state.TState;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GateState<T extends TState<T> & GateState<T>>
extends TState<T> {
    public StateType gateState();

    public static enum StateType {
        CLOSED,
        OPENING,
        OPEN;

    }

    public static class Open
    implements GateState<Open>,
    NbtSerializer {
        public static final TState.Type<Open> state = new TState.NbtBacked<Open>(StargateMod.id("generic/open")){

            public Open fromNbt(@NotNull class_2487 nbt, boolean isClient) {
                long address = NbtUtil.getLong(nbt, "address", -1L);
                boolean caller = nbt.method_10577("caller");
                return new Open(StargateRef.resolveGlobal(address, isClient), caller);
            }
        };
        public static final int TICKS_PER_OPEN = 1200;
        public static final int TELEPORT_FREQUENCY = 10;
        public static final int TELEPORT_DELAY = 20;
        @Nullable
        public final Stargate target;
        public final boolean caller;
        public int timer;

        public Open(@Nullable Stargate target, boolean caller) {
            this.target = target;
            this.caller = caller;
        }

        public void toNbt(@NotNull class_2487 nbt, boolean isClient) {
            if (this.target != null) {
                nbt.method_10544("address", this.target.globalAddress());
            }
            nbt.method_10556("caller", this.caller);
        }

        public TState.Type<Open> type() {
            return state;
        }

        @Override
        public StateType gateState() {
            return StateType.OPEN;
        }
    }

    public static final class Opening
    implements GateState<Opening>,
    NbtSerializer {
        public static final TState.Type<Opening> state = new TState.NbtBacked<Opening>(StargateMod.id("generic/opening")){

            public Opening fromNbt(@NotNull class_2487 nbt, boolean isClient) {
                long address = NbtUtil.getLong(nbt, "address", -1L);
                boolean caller = nbt.method_10577("caller");
                int timer = nbt.method_10550("timer");
                float kawooshHeight = nbt.method_10583("kawooshHeight");
                return new Opening(StargateRef.resolveGlobal(address, isClient), caller, timer, kawooshHeight);
            }
        };
        public static final int TICKS_PER_KAWOOSH = 80;
        @Nullable
        public final Stargate target;
        public final boolean caller;
        public int timer;
        public float kawooshHeight;

        public Opening(Stargate target, boolean caller) {
            this(target, caller, 0, 0.0f);
        }

        private Opening(@Nullable Stargate target, boolean caller, int timer, float kawooshHeight) {
            this.target = target;
            this.caller = caller;
            this.timer = timer;
            this.kawooshHeight = kawooshHeight;
        }

        public void toNbt(@NotNull class_2487 nbt, boolean isClient) {
            if (this.target != null) {
                nbt.method_10544("address", this.target.globalAddress());
            }
            nbt.method_10556("caller", this.caller);
            nbt.method_10569("timer", this.timer);
            nbt.method_10548("kawooshHeight", this.kawooshHeight);
        }

        public TState.Type<Opening> type() {
            return state;
        }

        @Override
        public StateType gateState() {
            return StateType.OPENING;
        }
    }

    public static class Closed
    implements GateState<Closed>,
    NbtSerializer {
        public static final TState.Type<Closed> state = new TState.NbtBacked<Closed>(StargateMod.id("generic/closed")){

            public Closed fromNbt(@NotNull class_2487 nbt, boolean isClient) {
                return new Closed(nbt);
            }
        };
        public static final int TICKS_PER_GLYPH = 5;
        public int locked;
        public boolean locking;
        public String address;
        public int timer;

        public Closed() {
            this.address = "";
        }

        private Closed(class_2487 nbt) {
            this.locked = nbt.method_10550("locked");
            this.locking = nbt.method_10577("locking");
            this.address = nbt.method_10558("address");
        }

        public boolean address$contains(char c) {
            return this.address.indexOf(c) != -1;
        }

        public int glyphIdxAtChevron(int chevronIdx) {
            return Glyph.indexOf(this.address.charAt(chevronIdx));
        }

        public void toNbt(@NotNull class_2487 nbt, boolean isClient) {
            nbt.method_10569("locked", this.locked);
            nbt.method_10556("locking", this.locking);
            nbt.method_10582("address", this.address);
        }

        public TState.Type<Closed> type() {
            return state;
        }

        @Override
        public StateType gateState() {
            return StateType.CLOSED;
        }
    }
}

