/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.block.entities;

import dev.amble.lib.block.behavior.horizontal.HorizontalBlockBehavior;
import dev.amble.stargate.StargateMod;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.dhd.DHDArrangement;
import dev.amble.stargate.api.dhd.SymbolArrangement;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.block.entities.NearestLinkingBlockEntity;
import dev.amble.stargate.entities.DHDControlEntity;
import dev.amble.stargate.init.StargateBlockEntities;
import dev.amble.stargate.init.StargateSounds;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class DHDBlockEntity
extends NearestLinkingBlockEntity {
    private final Deque<DHDControlEntity> symbolControlEntities = new ArrayDeque<DHDControlEntity>(Glyph.ALL.length);
    private boolean needsSymbols = true;

    public DHDBlockEntity(class_2338 pos, class_2680 state) {
        super(StargateBlockEntities.DHD, pos, state, true);
    }

    public void onUseControl(class_1657 player, class_1937 world, DHDControlEntity entity, boolean leftClick) {
        Stargate stargate = this.asGate();
        if (stargate == null) {
            StargateMod.LOGGER.warn("Discarding invalid control entity at {}; dhd pos: {}", (Object)entity.method_19538(), (Object)this.method_11016());
            entity.method_31472();
            return;
        }
        world.method_8396(null, this.method_11016(), StargateSounds.DHD_PRESS, class_3419.field_15245, 0.7f, 1.0f);
        GateState.Closed closed = (GateState.Closed)stargate.stateOrNull(GateState.Closed.state);
        if (closed != null) {
            closed.address = closed.address + entity.getSymbol();
            stargate.markDirty();
        }
    }

    @Override
    public void onPlaced(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.onPlaced(world, pos, state, placer, itemStack);
        this.markNeedsControl();
    }

    @Override
    public void onBreak(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState) {
        this.killControls();
    }

    public void tick(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        if (this.needsSymbols) {
            this.spawnControls();
        }
    }

    @Override
    public class_2487 method_16887() {
        this.markNeedsControl();
        return super.method_16887();
    }

    @Override
    public boolean link(Stargate gate) {
        this.markNeedsControl();
        return super.link(gate);
    }

    public void method_11012() {
        this.killControls();
        super.method_11012();
    }

    private void killControls() {
        while (!this.symbolControlEntities.isEmpty()) {
            class_1297 entity = this.symbolControlEntities.poll();
            if (entity == null) continue;
            entity.method_31472();
        }
    }

    private void spawnControls() {
        if (this.field_11863.method_8608()) {
            return;
        }
        this.killControls();
        Stargate stargate = this.asGate();
        if (stargate == null) {
            return;
        }
        class_2350 direction = HorizontalBlockBehavior.getFacing((class_2680)this.field_11863.method_8320(this.field_11867));
        for (SymbolArrangement control : DHDArrangement.SYMBOLS) {
            this.symbolControlEntities.add(control.createEntity(this.field_11863, this.field_11867, direction));
        }
        this.symbolControlEntities.add(DHDArrangement.poi(this.field_11863).createEntity(this.field_11863, this.field_11867, direction));
        this.needsSymbols = false;
    }

    public void markNeedsControl() {
        this.needsSymbols = true;
    }
}

