/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.block.entities;

import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.api.data.StargateServerData;
import dev.amble.stargate.block.entities.StargateLinkableBlockEntity;
import java.util.Collection;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class NearestLinkingBlockEntity
extends StargateLinkableBlockEntity {
    private static final int[] OFFSETS = new int[]{0, -1, 1};
    private final boolean sendLinkMessage;

    public NearestLinkingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, boolean sendLinkMessage) {
        super(type, pos, state);
        this.sendLinkMessage = sendLinkMessage;
    }

    @Nullable
    public static Stargate findNearest(class_3218 world, class_2338 pos) {
        StargateServerData data = StargateServerData.get(world);
        if (data == null) {
            return null;
        }
        class_1923 chunkPos = new class_1923(pos);
        for (int offsetX : OFFSETS) {
            for (int offsetZ : OFFSETS) {
                Collection<Stargate> collection = data.findByChunk(chunkPos.field_9181 + offsetX, chunkPos.field_9180 + offsetZ);
                if (collection == null || collection.isEmpty()) continue;
                return collection.iterator().next();
            }
        }
        return null;
    }

    public void onPlaced(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        Stargate nearest = NearestLinkingBlockEntity.findNearest(serverWorld, pos);
        if (nearest == null) {
            return;
        }
        this.link(nearest);
        if (this.sendLinkMessage && placer instanceof class_3222) {
            class_3222 player = (class_3222)placer;
            player.method_7353((class_2561)class_2561.method_43471((String)"text.stargate.linked").method_27693(AddressProvider.Global.asString(this.ref.address())), true);
        }
    }
}

