/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client;

import com.mojang.brigadier.CommandDispatcher;
import dev.amble.stargate.StargateMod;
import dev.amble.stargate.client.api.data.StargateClientData;
import dev.amble.stargate.client.command.ClientStargateDataCommand;
import dev.amble.stargate.client.command.ClientStargateDumpCommand;
import dev.amble.stargate.client.init.StargateClientYAARs;
import dev.amble.stargate.client.overlays.WormholeOverlay;
import dev.amble.stargate.client.portal.PortalRendering;
import dev.amble.stargate.client.renderers.DHDBlockEntityRenderer;
import dev.amble.stargate.client.renderers.DHDControlEntityRenderer;
import dev.amble.stargate.client.renderers.RingBlockEntityRenderer;
import dev.amble.stargate.client.renderers.StargateBlockEntityRenderer;
import dev.amble.stargate.client.service.ClientStargateDataProviderService;
import dev.amble.stargate.client.service.ClientWorldProviderService;
import dev.amble.stargate.client.service.TooltipServiceImpl;
import dev.amble.stargate.fluid.StargateFluids;
import dev.amble.stargate.init.StargateBlockEntities;
import dev.amble.stargate.init.StargateBlocks;
import dev.amble.stargate.init.StargateEntities;
import dev.amble.stargate.service.StargateDataProviderService;
import dev.amble.stargate.service.TooltipService;
import dev.amble.stargate.service.WorldProviderService;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_3611;
import net.minecraft.class_5616;

@Environment(value=EnvType.CLIENT)
public class StargateModClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, access) -> {
            ClientStargateDataCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            ClientStargateDumpCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
        this.registerBlockEntityRenderers();
        StargateModClient.setupBlockRendering();
        this.registerEntityRenderers();
        WorldRenderEvents.AFTER_ENTITIES.register(PortalRendering::render);
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)StargateFluids.STILL_LIQUID_NAQUADAH, (class_3611)StargateFluids.FLOWING_LIQUID_NAQUADAH, (FluidRenderHandler)new SimpleFluidRenderHandler(StargateMod.id("block/liquid_naquadah_still"), StargateMod.id("block/liquid_naquadah_flow")));
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{StargateFluids.STILL_LIQUID_NAQUADAH, StargateFluids.FLOWING_LIQUID_NAQUADAH});
        HudRenderCallback.EVENT.register((Object)new WormholeOverlay());
        StargateClientYAARs.init();
        StargateClientData.init();
        TooltipService.INSTANCE = new TooltipServiceImpl();
        StargateDataProviderService.INSTANCE = new ClientStargateDataProviderService();
        WorldProviderService.INSTANCE = new ClientWorldProviderService();
    }

    public void registerBlockEntityRenderers() {
        class_5616.method_32144(StargateBlockEntities.GENERIC_STARGATE, StargateBlockEntityRenderer::new);
        class_5616.method_32144(StargateBlockEntities.DHD, DHDBlockEntityRenderer::new);
        class_5616.method_32144(StargateBlockEntities.RING, RingBlockEntityRenderer::new);
    }

    public void registerEntityRenderers() {
        EntityRendererRegistry.register(StargateEntities.DHD_CONTROL_TYPE, DHDControlEntityRenderer::new);
    }

    public static void setupBlockRendering() {
        BlockRenderLayerMap map = BlockRenderLayerMap.INSTANCE;
        map.putBlock((class_2248)StargateBlocks.GENERIC_GATE, class_1921.method_23581());
        map.putBlock((class_2248)StargateBlocks.ORLIN_GATE, class_1921.method_23581());
    }
}

