/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client.api.behavior;

import dev.amble.lib.block.behavior.horizontal.HorizontalBlockBehavior;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.event.init.StargateLoadedEvents;
import dev.amble.stargate.api.event.tick.StargateTickEvents;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.api.state.stargate.GateIdentityState;
import dev.amble.stargate.api.state.stargate.client.ClientAbstractStargateState;
import dev.amble.stargate.block.entities.StargateBlockEntity;
import dev.amble.stargate.client.api.event.render.StargateAnimateEvent;
import dev.amble.stargate.client.api.event.render.StargateRenderEvents;
import dev.amble.stargate.client.renderers.StargateBlockEntityRenderer;
import dev.amble.stargate.client.util.EmissionUtil;
import dev.drtheo.yaar.behavior.TBehavior;
import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;
import dev.drtheo.yaar.state.TState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2680;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public abstract class ClientAbstractStargateBehavior<T extends ClientAbstractStargateState>
implements TBehavior,
StargateRenderEvents,
StargateLoadedEvents,
StargateTickEvents {
    private final Class<T> clazz;
    private final Class<? extends GateIdentityState> identity;

    public ClientAbstractStargateBehavior(Class<? extends GateIdentityState> identity, Class<T> clazz) {
        this.clazz = clazz;
        this.identity = identity;
    }

    protected abstract T createClientState(Stargate var1);

    @Override
    public void onLoaded(Stargate stargate) {
        if (stargate.isClient() && this.identity.isInstance(stargate.state(GateIdentityState.state))) {
            stargate.addState((TState<?>)this.createClientState(stargate));
        }
    }

    @Override
    public void tick(Stargate stargate) {
        if (!stargate.isClient()) {
            return;
        }
        ++((ClientAbstractStargateState)stargate.resolveState(ClientAbstractStargateState.state)).age;
    }

    @Override
    public void render(Stargate stargate, ClientAbstractStargateState clientState, StargateBlockEntity entity, StargateBlockEntityRenderer renderer, class_3695 profiler, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, float tickDelta) {
        if (!this.shouldRender(stargate, clientState)) {
            return;
        }
        this.customRender(stargate, clientState, entity, renderer, profiler, matrices, vertexConsumers, light, overlay, tickDelta);
    }

    protected void customRender(Stargate stargate, ClientAbstractStargateState clientState, StargateBlockEntity entity, StargateBlockEntityRenderer renderer, class_3695 profiler, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, float tickDelta) {
        matrices.method_46416(0.5f, 1.4f, 0.5f);
        float k = HorizontalBlockBehavior.getFacing((class_2680)entity.method_11010()).method_10144();
        matrices.method_22907(class_7833.field_40715.rotationDegrees(k));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22905(1.0f, 1.0f, 1.0f);
        profiler.method_15396("glyphs");
        renderer.model.SymbolRing.field_3674 = renderer.renderGlyphs(clientState, matrices, vertexConsumers, stargate, light, clientState.age);
        profiler.method_15407();
        profiler.method_15396("animate");
        TEvents.handle((TEvent)new StargateAnimateEvent(entity, stargate, renderer.model, clientState.age));
        profiler.method_15407();
        boolean anyVisible = this.updateChevronVisibility(stargate, renderer);
        profiler.method_15396("render2layer");
        EmissionUtil.render2Layers(renderer.model, clientState.texture, clientState.emission, anyVisible, matrices, vertexConsumers, light, overlay);
        profiler.method_15407();
    }

    public boolean shouldRender(Stargate stargate, ClientAbstractStargateState state) {
        return this.clazz.isInstance(state);
    }

    public boolean updateChevronVisibility(Stargate stargate, StargateBlockEntityRenderer renderer) {
        int n;
        boolean visible;
        renderer.model.chev_light8.field_3665 = false;
        renderer.model.chev_light9.field_3665 = false;
        GateState<?> state = stargate.getGateState();
        boolean bl = visible = state.gateState() != GateState.StateType.CLOSED;
        if (state instanceof GateState.Closed) {
            GateState.Closed closed = (GateState.Closed)state;
            n = closed.locked;
        } else {
            n = -1;
        }
        int locked = n;
        class_630[] chevrons = renderer.chevrons;
        for (int i = 0; i < chevrons.length; ++i) {
            chevrons[i].field_3665 = visible || i < locked;
        }
        return visible || locked != 0;
    }
}

