/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client.api.data;

import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.data.StargateData;
import dev.amble.stargate.api.event.address.AddressListEvent;
import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StargateClientData
implements StargateData {
    private static StargateClientData INSTANCE;
    private final Long2ObjectMap<Stargate> lookup = new Long2ObjectOpenHashMap();

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(world -> StargateClientData.get().tick());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC, (client, networkHandler, buf, sender) -> {
            long globalId = buf.method_10792();
            class_2487 nbt = buf.method_10798();
            System.out.println("Received sg " + globalId);
            StargateClientData data = StargateClientData.get();
            Stargate stargate = data.getById(globalId);
            client.execute(() -> {
                if (stargate != null) {
                    stargate.updateStates(nbt, true);
                } else {
                    Stargate newStargate = Stargate.fromNbt(nbt, true);
                    TEvents.handle((TEvent)new AddressListEvent(newStargate, id -> data.addId(id, newStargate)));
                }
            });
        });
        INSTANCE = new StargateClientData();
    }

    private void tick() {
        for (Stargate stargate : this.lookup.values()) {
            stargate.tick();
        }
    }

    @Override
    public void addId(long id, Stargate stargate) {
        this.lookup.put(id, (Object)stargate);
    }

    @Override
    public void removeId(long id) {
        this.lookup.remove(id);
    }

    @Override
    public boolean containsId(long id) {
        return this.lookup.containsKey(id);
    }

    @Override
    @Nullable
    public Stargate getById(long id) {
        return (Stargate)this.lookup.get(id);
    }

    @NotNull
    public static StargateClientData get() {
        return INSTANCE;
    }
}

