/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client.portal;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.lib.block.behavior.horizontal.HorizontalBlockBehavior;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.api.state.stargate.client.ClientAbstractStargateState;
import dev.amble.stargate.block.entities.StargateBlockEntity;
import java.util.ArrayDeque;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class PortalRendering {
    public static final Queue<StargateBlockEntity> QUEUE = new ArrayDeque<StargateBlockEntity>();
    static final float maxWaveHeight = 0.006f;
    static final float minWaveHeight = 0.001f;
    static final float waveFrequency = 24.0f;
    static final float waveSpeed = 0.2f;
    static final float radius = 0.08f;
    static final float centerRadius = 0.072f;
    static final float coreRadius = 0.02f;
    static final float centralRadius = 0.05f;
    static final float centralHeight = 0.6f;
    static final float centralFreq = 0.01f;
    static final float centralSpeed = 0.2f;
    static final float centralOffset = 0.0f;
    static final float maxHeight = 0.00175f;
    static final int frames = 18;
    static final int sides = 18;
    static final int rings = 36;
    static final int rippleCount = 12;
    static final float[][] rippleCenters = new float[12][2];
    static final float[] rippleRadii = new float[12];
    static final float[] rippleHeights = new float[12];

    public static void render(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_4587 stack = context.matrixStack();
        float time = (float)client.field_1724.field_6012 / 200.0f * 100.0f;
        while (!QUEUE.isEmpty()) {
            ClientAbstractStargateState clientState;
            Stargate stargate;
            StargateBlockEntity gate = QUEUE.poll();
            if (gate == null || (stargate = gate.asGate()) == null || (clientState = (ClientAbstractStargateState)stargate.stateOrNull(ClientAbstractStargateState.state)) == null) continue;
            PortalRendering.render(client, stack, gate, stargate, clientState, time);
        }
    }

    public static void render(class_310 client, class_4587 stack, StargateBlockEntity entity, Stargate stargate, ClientAbstractStargateState clientState, float age) {
        class_243 pos = entity.method_11016().method_46558().method_1020(client.field_1773.method_19418().method_19326());
        stack.method_22903();
        stack.method_22904(pos.method_10216(), pos.method_10214(), pos.method_10215());
        stack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        stack.method_22907(class_7833.field_40716.rotationDegrees(HorizontalBlockBehavior.getFacing((class_2680)entity.method_11010()).method_10144()));
        stack.method_46416(0.0f, -2.0f, 0.0f);
        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        stack.method_46416(0.0f, clientState.portalYOffset, 0.0f);
        stack.method_22905((float)clientState.portalSize, (float)clientState.portalSize, (float)clientState.portalSize);
        GateState<?> state = stargate.getGateState();
        RenderSystem.enableDepthTest();
        PortalRendering.renderPortalInterior(stack, clientState, state, age);
        RenderSystem.disableDepthTest();
        stack.method_22909();
        stack.method_22909();
        stack.method_22909();
    }

    private static void renderPortalInterior(class_4587 matrixStack, ClientAbstractStargateState clientState, GateState<?> currentState, float time) {
        matrixStack.method_22903();
        RenderSystem.setShader(class_757::method_34548);
        class_2960 texture = clientState.portalType;
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_310.method_1551().method_1531().method_22813(texture);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27379, class_290.field_20888);
        RenderSystem.disableCull();
        PortalRendering.portalTriangles(matrixStack, (class_4588)buffer, currentState, time);
        tessellator.method_1350();
        RenderSystem.enableCull();
        matrixStack.method_22909();
    }

    private static void addVertexGlow(class_4588 builder, Matrix4f matrix, float x, float y, float z, float u, float v, float r) {
        r = Math.min(1.0f, r);
        builder.method_22918(matrix, x, y, z).method_22915(r, r, r, 1.0f).method_22913(u, v).method_22916(0xF000F0).method_1344();
    }

    private static void portalTriangles(class_4587 matrixStack, class_4588 buffer, GateState<?> currentState, float time) {
        int r;
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        boolean hasCentral = currentState.gateState() == GateState.StateType.OPENING;
        float[][][] mesh = new float[36][18][3];
        for (r = 0; r < 36; ++r) {
            float t = (float)r / 35.0f;
            float ringRadius = 0.08f * t;
            for (int i = 0; i < 18; ++i) {
                float distToCenter;
                float angle = (float)Math.PI * 2 * (float)i / 18.0f;
                float x = class_3532.method_15362((float)angle) * ringRadius;
                float y = class_3532.method_15374((float)angle) * ringRadius;
                float dz = 0.0f;
                if (r != 0 && r != 35) {
                    for (int rc = 0; rc < 12; ++rc) {
                        float rippleRadius;
                        float cx = rippleCenters[rc][0];
                        float cy = rippleCenters[rc][1];
                        float distToCenter2 = class_3532.method_15355((float)((x - cx) * (x - cx) + (y - cy) * (y - cy)));
                        if (!(distToCenter2 < (rippleRadius = rippleRadii[rc]))) continue;
                        float norm = 1.0f - distToCenter2 / rippleRadius;
                        float phase = time * 0.2f + (float)rc * 1.3f;
                        dz += class_3532.method_15374((float)(norm * 24.0f + phase)) * rippleHeights[rc] * norm * t;
                    }
                }
                if (hasCentral && (distToCenter = class_3532.method_15355((float)(x * x + y * y))) <= 0.05f) {
                    float norm = 1.0f - distToCenter / 0.05f;
                    float wave = PortalRendering.getWave(currentState, angle, norm, time);
                    float effect = wave >= 0.0f ? wave * 0.6f * norm * t : wave * 0.25f * 0.6f * norm * t;
                    if (distToCenter < 0.006f) {
                        effect = 0.0f;
                    }
                    dz += effect;
                    dz += wave * 0.6f * norm * 0.2f;
                }
                mesh[r][i][0] = x;
                mesh[r][i][1] = y;
                mesh[r][i][2] = dz;
            }
        }
        for (r = 0; r < 35; ++r) {
            for (int i = 0; i < 18; ++i) {
                float centerNorm0;
                float centerDist0;
                int next = (i + 1) % 18;
                int currentFrame = (int)(time % 18.0f);
                float[] v0 = mesh[r][i];
                float[] v1 = mesh[r + 1][i];
                float[] v2 = mesh[r + 1][next];
                float[] v3 = mesh[r][next];
                float u0 = v0[0] / 0.16f + 0.5f;
                float u1 = v1[0] / 0.16f + 0.5f;
                float u2 = v2[0] / 0.16f + 0.5f;
                float u3 = v3[0] / 0.16f + 0.5f;
                float v0t = (v0[1] / 0.16f + 0.5f) / 18.0f + (float)currentFrame / 18.0f;
                float v1t = (v1[1] / 0.16f + 0.5f) / 18.0f + (float)currentFrame / 18.0f;
                float v2t = (v2[1] / 0.16f + 0.5f) / 18.0f + (float)currentFrame / 18.0f;
                float v3t = (v3[1] / 0.16f + 0.5f) / 18.0f + (float)currentFrame / 18.0f;
                float dist0 = class_3532.method_15355((float)(v0[0] * v0[0] + v0[1] * v0[1]));
                float dist1 = class_3532.method_15355((float)(v1[0] * v1[0] + v1[1] * v1[1]));
                float dist2 = class_3532.method_15355((float)(v2[0] * v2[0] + v2[1] * v2[1]));
                float dist3 = class_3532.method_15355((float)(v3[0] * v3[0] + v3[1] * v3[1]));
                boolean centerTriangle = dist0 < 0.072f || dist1 < 0.072f || dist2 < 0.072f;
                boolean coreTriangle = dist0 < 0.02f || dist1 < 0.02f || dist2 < 0.02f;
                boolean centerTriangle2 = dist0 < 0.072f || dist2 < 0.072f || dist3 < 0.072f;
                boolean coreTriangle2 = dist0 < 0.02f || dist2 < 0.02f || dist3 < 0.02f;
                float intensity0 = class_3532.method_15363((float)((float)Math.pow(Math.max(0.0f, v0[2] / 0.00175f), 2.5)), (float)0.7f, (float)1.0f);
                float intensity1 = class_3532.method_15363((float)((float)Math.pow(Math.max(0.0f, v1[2] / 0.00175f), 2.5)), (float)0.7f, (float)1.0f);
                float intensity2 = class_3532.method_15363((float)((float)Math.pow(Math.max(0.0f, v2[2] / 0.00175f), 2.5)), (float)0.7f, (float)1.0f);
                float intensity3 = class_3532.method_15363((float)((float)Math.pow(Math.max(0.0f, v3[2] / 0.00175f), 2.5)), (float)0.7f, (float)1.0f);
                if (coreTriangle) {
                    intensity0 = Math.min(1.0f, intensity0 + 1.0f);
                    intensity1 = Math.min(1.0f, intensity1 + 1.0f);
                    intensity2 = Math.min(1.0f, intensity2 + 1.0f);
                } else if (centerTriangle) {
                    centerDist0 = (float)Math.sqrt(v0[0] * v0[0] + v0[1] * v0[1]);
                    float centerDist1 = (float)Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1]);
                    float centerDist2 = (float)Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1]);
                    centerNorm0 = 1.0f - Math.min(1.0f, centerDist0 / 0.072f);
                    float centerNorm1 = 1.0f - Math.min(1.0f, centerDist1 / 0.072f);
                    float centerNorm2 = 1.0f - Math.min(1.0f, centerDist2 / 0.072f);
                    intensity0 = Math.min(1.0f, intensity0 + 0.6f * centerNorm0);
                    intensity1 = Math.min(1.0f, intensity1 + 0.6f * centerNorm1);
                    intensity2 = Math.min(1.0f, intensity2 + 0.6f * centerNorm2);
                }
                PortalRendering.addVertexGlow(buffer, matrix, v0[0], v0[1], v0[2], u0, v0t, intensity0);
                PortalRendering.addVertexGlow(buffer, matrix, v1[0], v1[1], v1[2], u1, v1t, intensity1);
                PortalRendering.addVertexGlow(buffer, matrix, v2[0], v2[1], v2[2], u2, v2t, intensity2);
                if (coreTriangle2) {
                    intensity0 = Math.min(1.0f, intensity0 + 1.0f);
                    intensity2 = Math.min(1.0f, intensity2 + 1.0f);
                    intensity3 = Math.min(1.0f, intensity3 + 1.0f);
                } else if (centerTriangle2) {
                    centerDist0 = (float)Math.sqrt(v0[0] * v0[0] + v0[1] * v0[1]);
                    float centerDist2 = (float)Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1]);
                    float centerDist3 = (float)Math.sqrt(v3[0] * v3[0] + v3[1] * v3[1]);
                    centerNorm0 = 1.0f - Math.min(1.0f, centerDist0 / 0.072f);
                    float centerNorm2 = 1.0f - Math.min(1.0f, centerDist2 / 0.072f);
                    float centerNorm3 = 1.0f - Math.min(1.0f, centerDist3 / 0.072f);
                    intensity0 = Math.min(1.0f, intensity0 + 0.6f * centerNorm0);
                    intensity2 = Math.min(1.0f, intensity2 + 0.6f * centerNorm2);
                    intensity3 = Math.min(1.0f, intensity3 + 0.6f * centerNorm3);
                }
                PortalRendering.addVertexGlow(buffer, matrix, v0[0], v0[1], v0[2], u0, v0t, intensity0);
                PortalRendering.addVertexGlow(buffer, matrix, v2[0], v2[1], v2[2], u2, v2t, intensity2);
                PortalRendering.addVertexGlow(buffer, matrix, v3[0], v3[1], v3[2], u3, v3t, intensity3);
            }
        }
    }

    private static float getWave(GateState<?> currentState, float angle, float bulge, float time) {
        float f;
        if (currentState instanceof GateState.Opening) {
            GateState.Opening opening = (GateState.Opening)currentState;
            f = opening.kawooshHeight;
        } else {
            f = 0.0f;
        }
        float realHeight = f;
        float phase = 1.25f * realHeight * 0.2f + 0.0f;
        float twist = class_3532.method_15374((float)(time * 0.7f + angle * 2.5f)) * 0.1f;
        return class_3532.method_15374((float)(bulge * 0.01f + phase + twist));
    }

    static {
        for (int i = 0; i < 12; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / 12.0f + (float)i * 0.7f;
            float dist = 0.03f + 0.03f * (float)(i % 2);
            PortalRendering.rippleCenters[i][0] = class_3532.method_15362((float)angle) * dist;
            PortalRendering.rippleCenters[i][1] = class_3532.method_15374((float)angle) * dist;
            PortalRendering.rippleRadii[i] = 0.03f + 0.02f * (float)(i % 2);
            PortalRendering.rippleHeights[i] = 0.001f + 0.005f * ((float)(i + 1) / 12.0f);
        }
    }
}

