/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client.portal;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.stargate.StargateMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class WormholeRenderer {
    public final class_2960 TEXTURE_LOCATION;
    public final class_2960 SECOND_LAYER_LOCATION;
    public final class_2960 THIRD_LAYER_LOCATION;
    private final float distortionSpeed;
    private final float distortionSeparationFactor;
    private final float distortionFactor;
    private final float scale;
    private final float speed;
    private float time = 0.0f;

    public WormholeRenderer(class_2960 texture) {
        this.TEXTURE_LOCATION = texture;
        this.SECOND_LAYER_LOCATION = new class_2960(texture.method_12836(), texture.method_12832().substring(0, texture.method_12832().length() - 4) + "_second.png");
        this.THIRD_LAYER_LOCATION = new class_2960(texture.method_12836(), texture.method_12832().substring(0, texture.method_12832().length() - 4) + "_third.png");
        this.distortionSpeed = 0.5f;
        this.distortionSeparationFactor = 32.0f;
        this.distortionFactor = 2.0f;
        this.scale = 32.0f;
        this.speed = 4.0f;
    }

    public WormholeRenderer(String name) {
        this(StargateMod.id("textures/wormhole/" + name + ".png"));
    }

    public void renderWormhole(class_4587 matrixStack) {
        this.time += class_310.method_1551().method_1488() / 360.0f;
        matrixStack.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.TEXTURE_LOCATION);
        matrixStack.method_22905(this.scale, this.scale, this.scale);
        class_310.method_1551().method_1531().method_22813(this.TEXTURE_LOCATION);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        for (int i = 0; i < 64; ++i) {
            this.renderSection((class_4588)buffer, i, (float)class_310.method_1551().field_1724.field_6012 / 200.0f * -this.speed + this.time * this.speed, (float)Math.sin((double)i * Math.PI / 64.0), (float)Math.sin((double)(i + 1) * Math.PI / 64.0), matrixStack.method_23760().method_23762(), matrixStack.method_23760().method_23761());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.method_1350();
        matrixStack.method_22909();
    }

    public void renderWormholeLayer(class_4587 matrixStack, float scaleFactor) {
        class_2960 currentTexture;
        class_2960 class_29602 = currentTexture = scaleFactor == 1.5f ? this.SECOND_LAYER_LOCATION : this.THIRD_LAYER_LOCATION;
        if (class_310.method_1551().method_1478().method_14486(currentTexture).isEmpty()) {
            return;
        }
        this.renderWormholeLayer(matrixStack, scaleFactor, currentTexture);
    }

    private void renderWormholeLayer(class_4587 matrixStack, float scaleFactor, class_2960 layer) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34498);
        RenderSystem.setShaderTexture((int)0, (class_2960)layer);
        this.time += class_310.method_1551().method_1488() / 360.0f;
        matrixStack.method_22903();
        matrixStack.method_22905(this.scale / scaleFactor, this.scale / scaleFactor, this.scale);
        class_310.method_1551().method_1531().method_22813(layer);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
        for (int i = 0; i < 32; ++i) {
            this.renderSection((class_4588)buffer, i, (float)class_310.method_1551().field_1724.field_6012 / 200.0f * -this.speed + this.time * this.speed, (float)Math.sin((double)i * Math.PI / 32.0), (float)Math.sin((double)(i + 1) * Math.PI / 32.0), matrixStack.method_23760().method_23762(), matrixStack.method_23760().method_23761());
        }
        tessellator.method_1350();
        matrixStack.method_22909();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void renderSection(class_4588 builder, int zOffset, float textureDistanceOffset, float startScale, float endScale, Matrix3f matrix3f, Matrix4f matrix4f) {
        float panel = 0.16666667f;
        float sqrt = (float)Math.sqrt(3.0) / 2.0f;
        int vOffset = (double)((float)zOffset * panel + textureDistanceOffset) > 1.0 ? zOffset - 6 : zOffset;
        float distortion = this.computeDistortionFactor(this.time, zOffset);
        float distortionPlusOne = this.computeDistortionFactor(this.time, zOffset + 1);
        float panelDistanceOffset = panel + textureDistanceOffset;
        float vPanelOffset = (float)vOffset * panel + textureDistanceOffset;
        int uOffset = 0;
        float uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -startScale + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -endScale + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 1;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 2;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, endScale + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, startScale + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * -sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * -sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        uOffset = 3;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, startScale + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, endScale + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 4;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / 2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / 2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        uOffset = 5;
        uPanelOffset = (float)uOffset * panel;
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -endScale + distortionPlusOne, -zOffset - 1, uPanelOffset + panel, (float)vOffset * panel + panelDistanceOffset);
        this.addVertex(builder, matrix3f, matrix4f, 0.0f, -startScale + distortion, -zOffset, uPanelOffset + panel, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, startScale * sqrt, startScale / -2.0f + distortion, -zOffset, uPanelOffset, vPanelOffset);
        this.addVertex(builder, matrix3f, matrix4f, endScale * sqrt, endScale / -2.0f + distortionPlusOne, -zOffset - 1, uPanelOffset, (float)vOffset * panel + panelDistanceOffset);
    }

    private void addVertex(class_4588 builder, Matrix3f normalMatrix, Matrix4f matrix, float x, float y, float z, float u, float v) {
        builder.method_22918(matrix, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 0.0f, 0.0f).method_1344();
    }

    private float computeDistortionFactor(float time, int t) {
        return (float)(Math.sin((double)(time * this.distortionSpeed) * 2.0 * Math.PI + (double)((float)(13 - t) * this.distortionSeparationFactor)) * (double)this.distortionFactor) / 8.0f;
    }
}

