/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client.renderers;

import dev.amble.lib.block.behavior.horizontal.HorizontalBlockBehavior;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.block.entities.DHDBlockEntity;
import dev.amble.stargate.client.models.DHDModel;
import dev.amble.stargate.client.util.EmissionUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class DHDBlockEntityRenderer
implements class_827<DHDBlockEntity> {
    public static final class_2960 TEXTURE = new class_2960("stargate", "textures/blockentities/dhd.png");
    public static final class_2960 EMISSION = new class_2960("stargate", "textures/blockentities/dhd_emission.png");
    private final DHDModel model = new DHDModel(DHDModel.getTexturedModelData().method_32109());
    private final class_630[] allLights;

    public DHDBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_630[] bottomlights = new class_630[]{this.model.button6, this.model.button7, this.model.button8, this.model.button9, this.model.button10, this.model.button11, this.model.button12, this.model.button13, this.model.button14, this.model.button15, this.model.button16, this.model.button17, this.model.button18, this.model.button1, this.model.button2, this.model.button3, this.model.button4, this.model.button5};
        class_630[] toplights = new class_630[]{this.model.button19, this.model.button20, this.model.button21, this.model.button22, this.model.button23, this.model.button24, this.model.button25, this.model.button26, this.model.button27, this.model.button28, this.model.button29, this.model.button30, this.model.button31, this.model.button32, this.model.button33, this.model.button34, this.model.button35, this.model.button36};
        this.allLights = new class_630[bottomlights.length + toplights.length];
        System.arraycopy(bottomlights, 0, this.allLights, 0, bottomlights.length);
        System.arraycopy(toplights, 0, this.allLights, bottomlights.length, toplights.length);
    }

    /*
     * Unable to fully structure code
     */
    public void render(DHDBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        block10: {
            block9: {
                block8: {
                    gate = entity.asGate();
                    if (gate == null) {
                        return;
                    }
                    for (class_630 lights : this.allLights) {
                        lights.field_3665 = false;
                    }
                    matrices.method_22903();
                    matrices.method_46416(0.5f, 1.5f, 0.5f);
                    k = HorizontalBlockBehavior.getFacing((class_2680)entity.method_11010()).method_10144();
                    matrices.method_22907(class_7833.field_40715.rotationDegrees(k));
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                    state = gate.getGateState();
                    if (!(state instanceof GateState.Closed)) break block8;
                    closed = (GateState.Closed)state;
                    if (closed.locked > 6) ** GOTO lbl-1000
                }
                if (state instanceof GateState.Opening || state instanceof GateState.Open) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                bl = v0;
                this.model.dialbutton.field_3665 = bl == false;
                this.model.dialbuttonlight.field_3665 = bl;
                if (!(state instanceof GateState.Closed)) break block9;
                closed = (GateState.Closed)state;
                address = closed.address;
                this.updateGlow(address, closed.locked);
                break block10;
            }
            if (!(state instanceof GateState.Opening)) ** GOTO lbl-1000
            preOpen = (GateState.Opening)state;
            if (preOpen.target != null) {
                address = AddressProvider.Global.asString(preOpen.target.globalAddress());
                this.updateGlow(address, address.length() - 1);
            } else if (state instanceof GateState.Open) {
                open = (GateState.Open)state;
                if (open.target != null) {
                    address = AddressProvider.Global.asString(open.target.globalAddress());
                    this.updateGlow(address, address.length() - 1);
                }
            }
        }
        this.renderGlyphs(matrices, vertexConsumers, entity);
        EmissionUtil.render2Layers(this.model, DHDBlockEntityRenderer.TEXTURE, DHDBlockEntityRenderer.EMISSION, true, matrices, vertexConsumers, light, overlay);
        matrices.method_22909();
    }

    private void updateGlow(String address, int len) {
        if (address.isEmpty()) {
            return;
        }
        block0: for (int i = 0; i < len; ++i) {
            char target = address.charAt(i);
            for (int a = 0; a < Glyph.ALL.length; ++a) {
                if (Glyph.ALL[a] != target) continue;
                this.allLights[a].field_3665 = true;
                continue block0;
            }
        }
    }

    private void renderGlyphs(class_4587 matrices, class_4597 vertexConsumers, DHDBlockEntity dhd) {
        class_2561 text;
        double angle;
        int shiftedIndex;
        int i;
        class_327 renderer = class_310.method_1551().field_1772;
        class_2350 direction = HorizontalBlockBehavior.getFacing((class_2680)dhd.method_11010());
        boolean northern = direction == class_2350.field_11043 || direction == class_2350.field_11035;
        int multiplier = direction == class_2350.field_11039 || direction == class_2350.field_11043 ? 1 : -1;
        float xOffset = northern ? (float)direction.method_10148() * 0.3f * (float)multiplier : (float)direction.method_10165() * 0.3f * (float)multiplier;
        float zOffset = northern ? (float)direction.method_10165() * 0.24f * (float)multiplier : (float)direction.method_10148() * 0.24f * (float)multiplier;
        matrices.method_22903();
        matrices.method_46416(xOffset, 0.565f, zOffset);
        matrices.method_22905(0.025f, 0.025f, 0.025f);
        int length = class_3532.method_15386((float)((float)Glyph.ALL.length / 2.0f));
        matrices.method_22907(class_7833.field_40713.rotationDegrees(65.0f));
        matrices.method_46416(0.0f, -11.5f, 2.0f);
        int offset = -4;
        for (i = 0; i < length; ++i) {
            matrices.method_22903();
            shiftedIndex = (i + offset) % length;
            angle = Math.PI * 2 * (double)shiftedIndex / (double)length;
            matrices.method_22907(class_7833.field_40717.rotationDegrees(0.0f));
            matrices.method_22905(0.4f, 0.4f, 0.4f);
            matrices.method_22904(Math.sin(angle) * 18.95 * (double)2.35f, Math.cos(angle) * 18.95 * (double)2.35f, 0.0);
            matrices.method_22907(class_7833.field_40717.rotationDegrees((float)(180.0 + Math.toDegrees(angle))));
            text = Glyph.asText(Glyph.ALL[i]);
            renderer.method_30882(text, (float)(-renderer.method_27525((class_5348)text)) / 2.0f, -4.0f, 7303815, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, 0xF000F0);
            matrices.method_22909();
        }
        offset = -9;
        for (i = 0; i < length; ++i) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, -2.5f);
            shiftedIndex = (i + offset) % length;
            angle = Math.PI * 2 * (double)shiftedIndex / (double)length;
            matrices.method_22905(0.4f, 0.4f, 0.4f);
            matrices.method_22904(Math.sin(angle) * 18.95 * (double)1.55f, Math.cos(angle) * 18.95 * (double)1.55f, 0.0);
            matrices.method_22907(class_7833.field_40717.rotationDegrees((float)(180.0 + Math.toDegrees(angle))));
            text = Glyph.asText(Glyph.ALL[18 + i]);
            renderer.method_30882(text, (float)(-renderer.method_27525((class_5348)text)) / 2.0f, -4.0f, 7303815, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, 0xF000F0);
            matrices.method_22909();
        }
        matrices.method_22909();
    }
}

