/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.client.renderers;

import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.behavior.GenericGateBehaviors;
import dev.amble.stargate.api.state.GateState;
import dev.amble.stargate.api.state.stargate.client.ClientAbstractStargateState;
import dev.amble.stargate.block.entities.StargateBlockEntity;
import dev.amble.stargate.client.api.event.render.StargateRenderEvent;
import dev.amble.stargate.client.models.OrlinGateModel;
import dev.amble.stargate.client.models.StargateModel;
import dev.amble.stargate.client.portal.PortalRendering;
import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class StargateBlockEntityRenderer
implements class_827<StargateBlockEntity> {
    public static final OrlinGateModel ORLIN_GATE = new OrlinGateModel(OrlinGateModel.getTexturedModelData().method_32109());
    public final StargateModel model = new StargateModel(StargateModel.getTexturedModelData().method_32109());
    public final class_630[] chevrons;
    private static final int MAX_GLYPHS = Glyph.ALL.length;
    private static final class_5481[] GLYPHS = new class_5481[MAX_GLYPHS];
    private static final float[] GLYPH_WIDTHS = new float[MAX_GLYPHS];

    public StargateBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.chevrons = new class_630[]{this.model.chev_light, this.model.chev_light2, this.model.chev_light3, this.model.chev_light4, this.model.chev_light5, this.model.chev_light6, this.model.chev_light7, this.model.chev_light7bottom};
    }

    public void render(StargateBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        Stargate gate;
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("stargate");
        if (entity.getBlockSet() != null) {
            matrices.method_22903();
            class_2680 blockState = entity.getBlockSet();
            class_310.method_1551().method_1541().method_3355(blockState, entity.method_11016(), (class_1920)entity.method_10997(), matrices, vertexConsumers.getBuffer(class_4696.method_23679((class_2680)blockState)), true, entity.method_10997().field_9229);
            matrices.method_22909();
        }
        if ((gate = entity.asGate()) == null) {
            return;
        }
        matrices.method_22903();
        TEvents.handle((TEvent)new StargateRenderEvent(gate, entity, this, profiler, matrices, vertexConsumers, light, overlay, tickDelta));
        matrices.method_22909();
        if (gate.getGateState().gateState() != GateState.StateType.CLOSED) {
            PortalRendering.QUEUE.add(entity);
        }
        profiler.method_15407();
    }

    private boolean shouldRenderGlyphs(class_310 client, Stargate stargate) {
        class_243 pos = client.field_1773.method_19418().method_19326();
        return class_243.method_24953((class_2382)stargate.pos()).method_24802((class_2374)pos, 16.0);
    }

    public float renderGlyphs(ClientAbstractStargateState glyphState, class_4587 matrices, class_4597 vertexConsumers, Stargate gate, int light, int age) {
        class_310 client = class_310.method_1551();
        float rot = this.model.SymbolRing.field_3674 * 180.0f / (float)Math.PI;
        if (this.shouldRenderGlyphs(client, gate)) {
            int selectedGlyphIdx;
            class_327 renderer = client.field_1772;
            class_2350 direction = gate.facing();
            boolean northern = direction.method_10166() == class_2350.class_2351.field_11051;
            int multiplier = -direction.method_10171().method_10181();
            float xOffset = (float)(northern ? direction.method_10148() : direction.method_10165()) * 0.3f * (float)multiplier;
            float zOffset = (float)(northern ? direction.method_10165() : direction.method_10148()) * 0.24f * (float)multiplier;
            matrices.method_22903();
            matrices.method_46416(0.0f, -2.05f, 0.0f);
            matrices.method_46416(xOffset, 0.05f, zOffset);
            matrices.method_22905(0.025f, 0.025f, 0.025f);
            GateState.Closed closed = (GateState.Closed)gate.stateOrNull(GateState.Closed.state);
            int lockingChevronIdx = closed != null && (closed.locked > 0 || closed.locking) ? closed.locked : -1;
            int n = selectedGlyphIdx = closed != null && lockingChevronIdx != -1 && lockingChevronIdx < closed.address.length() ? closed.glyphIdxAtChevron(lockingChevronIdx) : -1;
            if (closed != null && closed.locking) {
                float rotProgress = (float)closed.timer / (float)GenericGateBehaviors.Closed.calculateDelay(closed);
                float selectedRot = 180.0f + 360.0f * (float)selectedGlyphIdx / (float)GLYPHS.length;
                System.out.println("rot: " + rot + "/" + class_3532.method_15393((float)selectedRot) + "; " + rotProgress * 100.0f + "%");
                rot += class_3532.method_15393((float)(class_3532.method_15393((float)selectedRot) * rotProgress - rot));
            }
            matrices.method_22907(class_7833.field_40718.rotationDegrees(rot));
            for (int i = 0; i < MAX_GLYPHS; ++i) {
                boolean isInDial = closed != null && closed.address.indexOf(Glyph.ALL[i]) != -1;
                boolean isSelected = isInDial && i == selectedGlyphIdx;
                float angle = (float)Math.PI * 2 * (float)i / (float)MAX_GLYPHS;
                int color = isInDial ? 6052979 : glyphState.glyphColor;
                int glyphLight = isSelected ? 0xF000F0 : light;
                matrices.method_22903();
                matrices.method_46416(class_3532.method_15374((float)angle) * 117.0f, class_3532.method_15362((float)angle) * 117.0f, 0.0f);
                matrices.method_22907(class_7833.field_40717.rotationDegrees((float)(180.0 + Math.toDegrees(angle))));
                renderer.method_22942(GLYPHS[i], GLYPH_WIDTHS[i], -4.0f, color, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33995, 0, glyphLight);
                matrices.method_22909();
            }
            matrices.method_22909();
        }
        return rot * (float)Math.PI / 180.0f;
    }

    static {
        class_327 renderer = class_310.method_1551().field_1772;
        for (int i = 0; i < MAX_GLYPHS; ++i) {
            class_5481 text;
            StargateBlockEntityRenderer.GLYPHS[i] = text = Glyph.asText(Glyph.ALL[i]).method_30937();
            StargateBlockEntityRenderer.GLYPH_WIDTHS[i] = (float)renderer.method_30880(text) / -2.0f;
        }
    }
}

