/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.item;

import dev.amble.lib.api.WorldUtil;
import dev.amble.stargate.api.Stargate;
import dev.amble.stargate.api.address.AddressProvider;
import dev.amble.stargate.api.address.Glyph;
import dev.amble.stargate.api.data.StargateData;
import dev.amble.stargate.service.StargateDataProviderService;
import dev.amble.stargate.service.TooltipContextExt;
import dev.amble.stargate.service.TooltipService;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public abstract class StargateLinkableItem
extends class_1792 {
    private final boolean showTooltip;

    public StargateLinkableItem(class_1792.class_1793 settings, boolean showTooltip) {
        super(settings);
        this.showTooltip = showTooltip;
    }

    public void link(class_1799 stack, Stargate gate) {
        this.link(stack, gate.globalAddress());
    }

    public void link(class_1799 stack, long address) {
        stack.method_7948().method_10544("Address", address);
    }

    public static boolean isLinked(class_1799 stack) {
        return stack.method_7948().method_10545("Address");
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        this.handleTooltip(stack, tooltip, TooltipService.INSTANCE.create(context));
    }

    private void handleTooltip(class_1799 stack, List<class_2561> tooltip, TooltipContextExt ctx) {
        if (!this.showTooltip) {
            return;
        }
        long id = StargateLinkableItem.getStargateAddressFromKey(stack, "Address");
        if (id == -1L) {
            return;
        }
        if (!ctx.isShiftDown()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.stargate.link_item.holdformoreinfo").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
            return;
        }
        Stargate stargate = StargateDataProviderService.INSTANCE.getClient().getGlobal(id);
        if (stargate != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.stargate.gate").method_10852((class_2561)class_2561.method_43470((String)": ")).method_27692(class_124.field_1078));
            class_5321<class_1937> dim = stargate.dimension();
            class_2338 pos = stargate.pos();
            class_2350 direction = stargate.facing();
            tooltip.add((class_2561)class_2561.method_43470((String)"> ").method_10852(Glyph.asText(AddressProvider.Global.asString(stargate.globalAddress()))).method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43470((String)"> ").method_10852(WorldUtil.worldText(dim)).method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43470((String)("> " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260())).method_27692(class_124.field_1063));
            tooltip.add((class_2561)class_2561.method_43470((String)("> " + String.valueOf(direction))).method_27692(class_124.field_1063));
        }
    }

    public static boolean isOf(class_1937 world, class_1799 stack, Stargate tardis) {
        return StargateLinkableItem.getStargate(world, stack) == tardis;
    }

    public static Stargate getStargate(class_1937 world, class_1799 stack) {
        return StargateLinkableItem.getStargateFromKey(world, stack, "Address");
    }

    public static long getStargateAddressFromKey(class_1799 stack, String path) {
        class_2487 nbt = stack.method_7948();
        class_2520 element = nbt.method_10580(path);
        if (element == null) {
            return -1L;
        }
        return nbt.method_10537(path);
    }

    public static Stargate getStargateFromKey(class_1937 world, class_1799 stack, String path) {
        return StargateLinkableItem.getStargate(world, StargateLinkableItem.getStargateAddressFromKey(stack, path));
    }

    public static Stargate getStargate(class_1937 world, long address) {
        return StargateData.apply(world, data -> data.getGlobal(address));
    }
}

