/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.stargate.service;

import dev.amble.stargate.api.data.StargateData;
import dev.amble.stargate.api.data.StargateServerData;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateDataProviderService {
    public static StargateDataProviderService INSTANCE = new StargateDataProviderService();

    public StargateData getClient() {
        throw new RuntimeException(new IllegalAccessException("Tried to access client stargate data on server!"));
    }

    @Nullable
    public StargateData get(class_1937 world) {
        StargateData stargateData;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            stargateData = StargateServerData.get(serverWorld);
        } else {
            stargateData = this.getClient();
        }
        return stargateData;
    }

    public void accept(class_1937 world, Consumer<StargateData> consumer) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            StargateServerData.accept(serverWorld, consumer::accept);
        } else {
            consumer.accept(this.getClient());
        }
    }

    @Nullable
    public <R> R apply(class_1937 world, Function<StargateData, R> func) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return (R)StargateServerData.apply(serverWorld, func::apply);
        }
        return func.apply(this.getClient());
    }

    @NotNull
    public StargateData getOrCreate(class_1937 world) {
        StargateData stargateData;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            stargateData = StargateServerData.getOrCreate(serverWorld);
        } else {
            stargateData = this.getClient();
        }
        return stargateData;
    }
}

